/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "corruptionMarker", "Ljava/io/File;", "getCorruptionMarker", "()Ljava/io/File;", "dropIndexes", "", "requestInvalidation", "requireInvalidation", "", "intellij.platform.lang.impl"})
public final class CorruptionMarker {
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    public static final CorruptionMarker INSTANCE;

    private final File getCorruptionMarker() {
        return new File(PathManager.getIndexRoot(), CORRUPTION_MARKER_NAME);
    }

    @JvmStatic
    public static final void requestInvalidation() {
        FileBasedIndexImpl.LOG.info("Requesting explicit indices invalidation");
        try {
            new FileOutputStream(INSTANCE.getCorruptionMarker()).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final boolean requireInvalidation() {
        return IndexInfrastructure.hasIndices() && INSTANCE.getCorruptionMarker().exists();
    }

    @JvmStatic
    public static final void dropIndexes() {
        File file2 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"PathManager.getIndexRoot()");
        File indexRoot = file2;
        FileUtil.deleteWithRenaming((File)indexRoot);
        indexRoot.mkdirs();
        SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
        ID.reinitializeDiskStorage();
        PersistentIndicesConfiguration.saveConfiguration();
        FileUtil.delete((File)INSTANCE.getCorruptionMarker());
        ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
        Object[] $this$forEach$iv = objectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv;
            boolean bl = false;
            it.clearPersistentData();
        }
    }

    private CorruptionMarker() {
    }

    static {
        CorruptionMarker corruptionMarker;
        INSTANCE = corruptionMarker = new CorruptionMarker();
    }
}

