/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileSetVersionsFetcherBase<FS extends DownloadableFileSetDescription, F extends DownloadableFileDescription>
implements DownloadableFileSetVersions<FS> {
    private static final Comparator<DownloadableFileSetDescription> VERSIONS_COMPARATOR = (o1, o2) -> -StringUtil.compareVersionNumbers((String)o1.getVersionString(), (String)o2.getVersionString());
    protected final String myGroupId;
    private final URL[] myLocalUrls;

    public FileSetVersionsFetcherBase(@Nullable String groupId2, URL @NotNull [] localUrls) {
        if (localUrls == null) {
            FileSetVersionsFetcherBase.$$$reportNull$$$0(0);
        }
        this.myLocalUrls = localUrls;
        this.myGroupId = groupId2;
    }

    public void fetchVersions(@NotNull DownloadableFileSetVersions.FileSetVersionsCallback<FS> callback2) {
        if (callback2 == null) {
            FileSetVersionsFetcherBase.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> callback2.onSuccess(this.fetchVersions()));
    }

    @NotNull
    public List<FS> fetchVersions() {
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Artifact[] versions = this.myGroupId != null ? LibrariesDownloadAssistant.getVersions((String)this.myGroupId, (URL[])this.myLocalUrls) : LibrariesDownloadAssistant.getVersions((URL[])this.myLocalUrls);
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Artifact version2 : versions) {
            ArtifactItem[] items = version2.getItems();
            ArrayList<F> files2 = new ArrayList<F>();
            for (ArtifactItem item : items) {
                Object url = item.getUrl();
                String prefix = version2.getUrlPrefix();
                if (url == null) {
                    if (prefix != null) {
                        url = prefix + item.getName();
                    }
                } else {
                    url = FileSetVersionsFetcherBase.prependPrefix((String)url, prefix);
                }
                assert (url != null);
                files2.add(this.createFileDescription(item, (String)url, prefix));
            }
            result2.add(this.createVersion(version2, files2));
        }
        result2.sort(VERSIONS_COMPARATOR);
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            FileSetVersionsFetcherBase.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected static String prependPrefix(@NotNull String url, @Nullable String prefix) {
        if (url == null) {
            FileSetVersionsFetcherBase.$$$reportNull$$$0(3);
        }
        if (!((String)url).startsWith("http://") && prefix != null) {
            url = prefix + (String)url;
        }
        String string = url;
        if (string == null) {
            FileSetVersionsFetcherBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected abstract F createFileDescription(ArtifactItem var1, String var2, @Nullable String var3);

    protected abstract FS createVersion(Artifact var1, List<F> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localUrls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/download/impl/FileSetVersionsFetcherBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/download/impl/FileSetVersionsFetcherBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prependPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersions";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prependPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

