/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.ui.win.RecentTasks;
import com.intellij.ui.win.Task;
import java.io.File;
import java.util.List;

public final class WinDockDelegate
implements SystemDock.Delegate {
    private static SystemDock.Delegate instance;

    public static synchronized SystemDock.Delegate getInstance() {
        if (instance == null) {
            instance = new WinDockDelegate();
        }
        return instance;
    }

    private WinDockDelegate() {
    }

    @Override
    public void updateRecentProjectsMenu() {
        List<AnAction> recentProjectActions = RecentProjectListActionProvider.getInstance().getActions(false);
        RecentTasks.clear();
        String name = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName());
        String launcher = RecentTasks.getShortenPath(PathManager.getBinPath() + File.separator + name + (SystemInfo.is64Bit ? "64" : "") + ".exe");
        Task[] tasks = new Task[recentProjectActions.size()];
        for (int i2 = 0; i2 < recentProjectActions.size(); ++i2) {
            ReopenProjectAction rpa = (ReopenProjectAction)recentProjectActions.get(i2);
            tasks[i2] = new Task(launcher, RecentTasks.getShortenPath(rpa.getProjectPath()), rpa.getTemplatePresentation().getText());
        }
        RecentTasks.addTasks(tasks);
    }
}

