/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeferredIconImpl<T>
extends JBScalableIcon
implements DeferredIcon,
RetrievableIcon,
IconWithToolTip,
CopyableIcon {
    private static final Logger LOG = Logger.getInstance(DeferredIconImpl.class);
    private static final int MIN_AUTO_UPDATE_MILLIS = 950;
    private static final RepaintScheduler ourRepaintScheduler = new RepaintScheduler();
    @NotNull
    private final Icon myDelegateIcon;
    @NotNull
    private volatile Icon myScaledDelegateIcon;
    private DeferredIconImpl<T> myScaledIconCache;
    private Function<? super T, ? extends Icon> myEvaluator;
    private volatile boolean myIsScheduled;
    private final T myParam;
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)16).withIconPreScaled(false);
    private final boolean myNeedReadAction;
    private boolean myDone;
    private final boolean myAutoUpdatable;
    private long myLastCalcTime;
    private long myLastTimeSpent;
    private static final ExecutorService ourIconCalculatingExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"OurIconCalculating Pool", (int)1);
    private final IconListener<T> myEvalListener;

    private DeferredIconImpl(@NotNull DeferredIconImpl<T> icon2) {
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(0);
        }
        super(icon2);
        this.myDelegateIcon = icon2.myDelegateIcon;
        this.myScaledDelegateIcon = icon2.myDelegateIcon;
        this.myScaledIconCache = null;
        this.myEvaluator = icon2.myEvaluator;
        this.myIsScheduled = icon2.myIsScheduled;
        this.myParam = icon2.myParam;
        this.myNeedReadAction = icon2.myNeedReadAction;
        this.myDone = icon2.myDone;
        this.myAutoUpdatable = icon2.myAutoUpdatable;
        this.myLastCalcTime = icon2.myLastCalcTime;
        this.myLastTimeSpent = icon2.myLastTimeSpent;
        this.myEvalListener = icon2.myEvalListener;
    }

    @NotNull
    public DeferredIconImpl<T> copy() {
        return new DeferredIconImpl<T>(this);
    }

    @NotNull
    public DeferredIconImpl<T> scale(float scale) {
        if (this.getScale() == scale) {
            DeferredIconImpl deferredIconImpl = this;
            if (deferredIconImpl == null) {
                DeferredIconImpl.$$$reportNull$$$0(1);
            }
            return deferredIconImpl;
        }
        DeferredIconImpl<T> icon2 = this.myScaledIconCache;
        if (icon2 == null || icon2.getScale() != scale) {
            icon2 = new DeferredIconImpl<T>(this);
            icon2.setScale(ScaleType.OBJ_SCALE.of((double)scale));
            this.myScaledIconCache = icon2;
        }
        icon2.myScaledDelegateIcon = IconUtil.scale((Icon)icon2.myDelegateIcon, null, (float)scale);
        DeferredIconImpl<T> deferredIconImpl = icon2;
        if (deferredIconImpl == null) {
            DeferredIconImpl.$$$reportNull$$$0(2);
        }
        return deferredIconImpl;
    }

    DeferredIconImpl(Icon baseIcon, T param, @NotNull Function<? super T, ? extends Icon> evaluator, @NotNull IconListener<T> listener2, boolean autoUpdatable) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(4);
        }
        this(baseIcon, (T)param, true, (Function<? super T, Icon>)evaluator, (IconListener<? super T>)listener2, autoUpdatable);
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull com.intellij.util.Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(5);
        }
        this(baseIcon, param, needReadAction, t -> (Icon)evaluator.fun(t), null, false);
    }

    private DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull Function<? super T, ? extends Icon> evaluator, @Nullable IconListener<T> listener2, boolean autoUpdatable) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(6);
        }
        this.myParam = param;
        this.myScaledDelegateIcon = this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myScaledIconCache = null;
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
        this.myEvalListener = listener2;
        this.myAutoUpdatable = autoUpdatable;
        this.checkDelegationDepth();
    }

    @NotNull
    public Icon getBaseIcon() {
        Icon icon2 = this.myDelegateIcon;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(7);
        }
        return icon2;
    }

    private void checkDelegationDepth() {
        int depth;
        DeferredIconImpl each = this;
        for (depth = 0; each.myScaledDelegateIcon instanceof DeferredIconImpl && depth < 50; ++depth) {
            each = (DeferredIconImpl)((Object)each.myScaledDelegateIcon);
        }
        if (depth >= 50) {
            LOG.error("Too deep deferred icon nesting");
        }
    }

    @NotNull
    private static Icon nonNull(@Nullable Icon icon2) {
        Icon icon3 = icon2 == null ? EMPTY_ICON : icon2;
        if (icon3 == null) {
            DeferredIconImpl.$$$reportNull$$$0(8);
        }
        return icon3;
    }

    public void paintIcon(Component c, @NotNull Graphics g, int x, int y) {
        if (g == null) {
            DeferredIconImpl.$$$reportNull$$$0(9);
        }
        if (!(this.myScaledDelegateIcon instanceof DeferredIconImpl) || !(((DeferredIconImpl)((Object)this.myScaledDelegateIcon)).myScaledDelegateIcon instanceof DeferredIconImpl)) {
            this.myScaledDelegateIcon.paintIcon(c, g, x, y);
        }
        if (this.isDone() || this.myIsScheduled || PowerSaveMode.isEnabled()) {
            return;
        }
        this.scheduleEvaluation(c, x, y);
    }

    @VisibleForTesting
    Future<?> scheduleEvaluation(Component c, int x, int y) {
        this.myIsScheduled = true;
        Component target2 = DeferredIconImpl.getTarget(c);
        Container paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c);
        Rectangle paintingParentRec = paintingParent == null ? null : ((PaintingParent)paintingParent).getChildRec(c);
        return ourIconCalculatingExecutor.submit(() -> {
            Icon result2;
            int oldWidth = this.myScaledDelegateIcon.getIconWidth();
            Icon[] evaluated = new Icon[1];
            long startTime = System.currentTimeMillis();
            if (this.myNeedReadAction) {
                boolean result3 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    IconDeferrerImpl.evaluateDeferred(() -> {
                        evaluated[0] = this.evaluate();
                    });
                    if (this.myAutoUpdatable) {
                        this.myLastCalcTime = System.currentTimeMillis();
                        this.myLastTimeSpent = this.myLastCalcTime - startTime;
                    }
                });
                if (!result3) {
                    this.myIsScheduled = false;
                    return;
                }
            } else {
                IconDeferrerImpl.evaluateDeferred(() -> {
                    evaluated[0] = this.evaluate();
                });
                if (this.myAutoUpdatable) {
                    this.myLastCalcTime = System.currentTimeMillis();
                    this.myLastTimeSpent = this.myLastCalcTime - startTime;
                }
            }
            this.myScaledDelegateIcon = result2 = evaluated[0];
            this.checkDelegationDepth();
            boolean shouldRevalidate = Registry.is((String)"ide.tree.deferred.icon.invalidates.cache") && this.myScaledDelegateIcon.getIconWidth() != oldWidth;
            EdtExecutorService.getInstance().execute(() -> {
                this.setDone(result2);
                if (DeferredIconImpl.equalIcons(result2, this.myDelegateIcon)) {
                    return;
                }
                Component actualTarget = target2;
                if (actualTarget != null && SwingUtilities.getWindowAncestor(actualTarget) == null && ((actualTarget = paintingParent) == null || SwingUtilities.getWindowAncestor(actualTarget) == null)) {
                    actualTarget = null;
                }
                if (actualTarget == null) {
                    return;
                }
                if (shouldRevalidate && actualTarget instanceof JTree) {
                    TreeUI ui = ((JTree)actualTarget).getUI();
                    TreeUtil.invalidateCacheAndRepaint((TreeUI)ui);
                }
                if (c == actualTarget) {
                    c.repaint(x, y, this.getIconWidth(), this.getIconHeight());
                } else {
                    ourRepaintScheduler.pushDirtyComponent(actualTarget, paintingParentRec);
                }
            });
        });
    }

    private static Component getTarget(Component c) {
        Container tabLabel;
        Container box;
        Container table;
        Container tree;
        Container list2 = SwingUtilities.getAncestorOfClass(JList.class, c);
        Component target2 = list2 != null ? list2 : ((tree = SwingUtilities.getAncestorOfClass(JTree.class, c)) != null ? tree : ((table = SwingUtilities.getAncestorOfClass(JTable.class, c)) != null ? table : ((box = SwingUtilities.getAncestorOfClass(JComboBox.class, c)) != null ? box : ((tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c)) == null ? c : tabLabel))));
        return target2;
    }

    private void setDone(@NotNull Icon result2) {
        if (result2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(10);
        }
        if (this.myEvalListener != null) {
            this.myEvalListener.evalDone(this, this.myParam, result2);
        }
        this.myDone = true;
        if (!this.myAutoUpdatable) {
            this.myEvaluator = null;
        }
    }

    @NotNull
    public Icon retrieveIcon() {
        Icon icon2 = this.isDone() ? this.myScaledDelegateIcon : this.evaluate();
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    public boolean isNeedReadAction() {
        return this.myNeedReadAction;
    }

    @NotNull
    public Icon evaluate() {
        Icon result2;
        try {
            result2 = DeferredIconImpl.nonNull(this.myEvaluator.apply(this.myParam));
        }
        catch (IndexNotReadyException e) {
            result2 = EMPTY_ICON;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkDoesntReferenceThis(result2);
        }
        if (this.getScale() != 1.0f && result2 instanceof ScalableIcon) {
            result2 = ((ScalableIcon)result2).scale(this.getScale());
        }
        Icon icon2 = result2;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(12);
        }
        return icon2;
    }

    private void checkDoesntReferenceThis(Icon icon2) {
        block4: {
            block5: {
                block3: {
                    if (icon2 == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon2 instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)((Object)icon2)).myScaledDelegateIcon);
                    break block4;
                }
                if (!(icon2 instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon2).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon2 instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon2;
            int count = rowIcon.getIconCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i2));
            }
        }
    }

    public int getIconWidth() {
        return this.myScaledDelegateIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myScaledDelegateIcon.getIconHeight();
    }

    public String getToolTip(boolean composite) {
        if (this.myScaledDelegateIcon instanceof IconWithToolTip) {
            return ((IconWithToolTip)this.myScaledDelegateIcon).getToolTip(composite);
        }
        return null;
    }

    public boolean isDone() {
        if (this.myAutoUpdatable && this.myDone && this.myLastCalcTime > 0L && System.currentTimeMillis() - this.myLastCalcTime > Math.max(950L, 10L * this.myLastTimeSpent)) {
            this.myDone = false;
            this.myIsScheduled = false;
        }
        return this.myDone;
    }

    public boolean equals(Object obj) {
        return obj instanceof DeferredIconImpl && DeferredIconImpl.paramsEqual(this, (DeferredIconImpl)((Object)obj));
    }

    public int hashCode() {
        return Objects.hash(this.myParam, this.myScaledDelegateIcon);
    }

    static boolean equalIcons(Icon icon1, Icon icon2) {
        if (icon1 instanceof DeferredIconImpl && icon2 instanceof DeferredIconImpl) {
            return DeferredIconImpl.paramsEqual((DeferredIconImpl)((Object)icon1), (DeferredIconImpl)((Object)icon2));
        }
        return Objects.equals(icon1, icon2);
    }

    private static boolean paramsEqual(@NotNull DeferredIconImpl<?> icon1, @NotNull DeferredIconImpl<?> icon2) {
        if (icon1 == null) {
            DeferredIconImpl.$$$reportNull$$$0(13);
        }
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(14);
        }
        return Comparing.equal(icon1.myParam, icon2.myParam) && DeferredIconImpl.equalIcons(icon1.myScaledDelegateIcon, icon2.myScaledDelegateIcon);
    }

    public String toString() {
        return "Deferred. Base=" + this.myScaledDelegateIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nonNull";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDone";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paramsEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface IconListener<T> {
        public void evalDone(@NotNull DeferredIconImpl<T> var1, T var2, @NotNull Icon var3);
    }

    private static final class RepaintRequest {
        final Component component;
        final Rectangle rectangle;

        private RepaintRequest(@NotNull Component component2, @Nullable Rectangle rectangle) {
            if (component2 == null) {
                RepaintRequest.$$$reportNull$$$0(0);
            }
            this.component = component2;
            this.rectangle = rectangle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepaintRequest request = (RepaintRequest)o;
            return this.component.equals(request.component) && Objects.equals(this.rectangle, request.rectangle);
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = 31 * result2 + (this.rectangle != null ? this.rectangle.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/DeferredIconImpl$RepaintRequest", "<init>"));
        }
    }

    private static class RepaintScheduler {
        private final Alarm myAlarm = new Alarm();
        private final Set<RepaintRequest> myQueue = new LinkedHashSet<RepaintRequest>();

        private RepaintScheduler() {
        }

        private void pushDirtyComponent(@NotNull Component c, Rectangle rec) {
            if (c == null) {
                RepaintScheduler.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> {
                for (RepaintRequest each : this.myQueue) {
                    Rectangle r = each.rectangle;
                    if (r == null) {
                        each.component.repaint();
                        continue;
                    }
                    each.component.repaint(r.x, r.y, r.width, r.height);
                }
                this.myQueue.clear();
            }, 50);
            this.myQueue.add(new RepaintRequest(c, rec));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/DeferredIconImpl$RepaintScheduler", "pushDirtyComponent"));
        }
    }
}

