/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.jediterm.terminal.TerminalDataStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;

public class AppendableTerminalDataStream
implements TerminalDataStream,
Appendable {
    private final LinkedBlockingDeque<Character> myQueue = new LinkedBlockingDeque(10000000);
    private final LinkedBlockingDeque<Character> myPushBackQueue = new LinkedBlockingDeque();

    public char getChar() throws IOException {
        Character ch = this.myPushBackQueue.poll();
        if (ch != null) {
            return ch.charValue();
        }
        try {
            return this.myQueue.take().charValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void pushChar(char c) {
        this.myPushBackQueue.addFirst(Character.valueOf(c));
    }

    public String readNonControlCharacters(int maxLength) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < maxLength) {
            Character c = this.myPushBackQueue.peek();
            if (c != null) {
                if (c.charValue() < ' ') break;
                sb.append(this.myPushBackQueue.poll());
                continue;
            }
            c = this.myQueue.peek();
            if (c == null || c.charValue() < ' ') break;
            sb.append(this.myQueue.poll());
        }
        return sb.toString();
    }

    public void pushBackBuffer(char[] chars, int length) {
        for (int i2 = length - 1; i2 >= 0; --i2) {
            this.myPushBackQueue.addFirst(Character.valueOf(chars[i2]));
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start2, int end) throws IOException {
        for (int i2 = start2; i2 < end; ++i2) {
            this.append(csq.charAt(i2));
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        try {
            this.myQueue.put(Character.valueOf(c));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return this;
    }
}

