/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.refactoring.rename.api.FileOperation;
import com.intellij.refactoring.rename.api.ModifiableRenameUsage;
import com.intellij.refactoring.rename.api.PsiRenameUsage;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.util.text.StringOperation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB>\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012'\u0010\u0007\u001a#\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u001cH\u0016R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR/\u0010\u0007\u001a#\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/refactoring/rename/impl/TextUsage;", "Lcom/intellij/refactoring/rename/api/PsiRenameUsage;", "Lcom/intellij/refactoring/rename/api/ModifiableRenameUsage;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "textReplacement", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "newName", "Lcom/intellij/refactoring/rename/impl/TextReplacement;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;)V", "declaration", "", "getDeclaration", "()Z", "getFile", "()Lcom/intellij/psi/PsiFile;", "fileUpdater", "Lcom/intellij/refactoring/rename/api/ModifiableRenameUsage$FileUpdater;", "getFileUpdater", "()Lcom/intellij/refactoring/rename/api/ModifiableRenameUsage$FileUpdater;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "createPointer", "Lcom/intellij/model/Pointer;", "Companion", "TextUsagePointer", "TextUsageUpdater", "intellij.platform.lang.impl"})
public final class TextUsage
implements PsiRenameUsage,
ModifiableRenameUsage {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    private final Function1<String, String> textReplacement;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getDeclaration() {
        return false;
    }

    @NotNull
    public Pointer<? extends TextUsage> createPointer() {
        return new TextUsagePointer(this.getFile(), this.getRange(), this.textReplacement);
    }

    @Override
    @Nullable
    public ModifiableRenameUsage.FileUpdater getFileUpdater() {
        return TextUsageUpdater.INSTANCE;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    public TextUsage(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull Function1<? super String, String> textReplacement) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(textReplacement, (String)"textReplacement");
        this.file = file2;
        this.range = range2;
        this.textReplacement = textReplacement;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B>\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012'\u0010\u0007\u001a#\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a#\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/refactoring/rename/impl/TextUsage$TextUsagePointer;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/refactoring/rename/impl/TextUsage;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "textReplacement", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "newName", "Lcom/intellij/refactoring/rename/impl/TextReplacement;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;)V", "rangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "dereference", "intellij.platform.lang.impl"})
    private static final class TextUsagePointer
    implements Pointer<TextUsage> {
        private final SmartPsiFileRange rangePointer;
        private final Function1<String, String> textReplacement;

        @Nullable
        public TextUsage dereference() {
            Segment segment;
            PsiFile file2;
            block5: {
                block4: {
                    PsiFile psiFile = (PsiFile)this.rangePointer.getElement();
                    if (psiFile == null) {
                        return null;
                    }
                    file2 = psiFile;
                    segment = this.rangePointer.getRange();
                    if (segment == null) break block4;
                    Segment segment2 = segment;
                    boolean bl = false;
                    boolean bl2 = false;
                    Segment p1 = segment2;
                    boolean bl3 = false;
                    segment = TextRange.create((Segment)p1);
                    if (segment != null) break block5;
                }
                return null;
            }
            Segment range2 = segment;
            return new TextUsage(file2, (TextRange)range2, this.textReplacement);
        }

        public TextUsagePointer(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull Function1<? super String, String> textReplacement) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            Intrinsics.checkNotNullParameter(textReplacement, (String)"textReplacement");
            this.textReplacement = textReplacement;
            SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiFileRangePointer(file2, range2);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"SmartPointerManager.getI\u2026RangePointer(file, range)");
            this.rangePointer = smartPsiFileRange;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/refactoring/rename/impl/TextUsage$TextUsageUpdater;", "Lcom/intellij/refactoring/rename/api/ModifiableRenameUsage$FileUpdater;", "()V", "prepareFileUpdate", "", "Lcom/intellij/refactoring/rename/api/FileOperation;", "usage", "Lcom/intellij/refactoring/rename/api/ModifiableRenameUsage;", "newName", "", "intellij.platform.lang.impl"})
    private static final class TextUsageUpdater
    implements ModifiableRenameUsage.FileUpdater {
        public static final TextUsageUpdater INSTANCE;

        @Override
        @NotNull
        public Collection<FileOperation> prepareFileUpdate(@NotNull ModifiableRenameUsage usage, @NotNull String newName2) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
            TextUsage cfr_ignored_0 = (TextUsage)usage;
            String string = (String)((TextUsage)usage).textReplacement.invoke((Object)newName2);
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String newText = string;
            PsiFile psiFile = ((TextUsage)usage).getFile();
            StringOperation stringOperation = StringOperation.replace((TextRange)((TextUsage)usage).getRange(), (CharSequence)newText);
            Intrinsics.checkNotNullExpressionValue((Object)stringOperation, (String)"StringOperation.replace(usage.range, newText)");
            return CollectionsKt.listOf((Object)FileOperation.Companion.modifyFile(psiFile, stringOperation, new StringOperation[0]));
        }

        private TextUsageUpdater() {
        }

        static {
            TextUsageUpdater textUsageUpdater;
            INSTANCE = textUsageUpdater = new TextUsageUpdater();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2'\u0010\t\u001a#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\u000fJ?\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2'\u0010\t\u001a#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/refactoring/rename/impl/TextUsage$Companion;", "", "()V", "createTextUsage", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "element", "Lcom/intellij/psi/PsiElement;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "textReplacement", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "newName", "Lcom/intellij/refactoring/rename/impl/TextReplacement;", "file", "Lcom/intellij/psi/PsiFile;", "rangeInFile", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final RenameUsage createTextUsage(@NotNull PsiElement element2, @NotNull TextRange rangeInElement, @NotNull Function1<? super String, String> textReplacement) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
            Intrinsics.checkNotNullParameter(textReplacement, (String)"textReplacement");
            if (element2 instanceof PsiFile) {
                return this.createTextUsage((PsiFile)element2, rangeInElement, textReplacement);
            }
            PsiFile psiFile = element2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
            TextRange textRange = element2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            TextRange textRange2 = rangeInElement.shiftRight(textRange.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"rangeInElement.shiftRigh\u2026nt.textRange.startOffset)");
            return this.createTextUsage(psiFile, textRange2, textReplacement);
        }

        @NotNull
        public final RenameUsage createTextUsage(@NotNull PsiFile file2, @NotNull TextRange rangeInFile, @NotNull Function1<? super String, String> textReplacement) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)rangeInFile, (String)"rangeInFile");
            Intrinsics.checkNotNullParameter(textReplacement, (String)"textReplacement");
            return new TextUsage(file2, rangeInFile, textReplacement);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

