/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public final class MinifiedFilesUtil {
    private static final int MAX_OFFSET = 2048;
    private static final int MIN_SIZE = 150;
    private static final double MAX_UNNEEDED_OFFSET_PERCENTAGE = 0.01;
    private static final int COUNT_OF_CONSIDERING_CHARACTERS_FROM_END_OF_FILE = 400;

    private MinifiedFilesUtil() {
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet) {
        if (fileContent == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(0);
        }
        if (parserDefinition == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(1);
        }
        if (noWSRequireBeforeTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(2);
        }
        if (noWSRequireAfterTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(3);
        }
        return MinifiedFilesUtil.isMinified(fileContent, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, parserDefinition.getStringLiteralElements());
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet, @NotNull TokenSet stringsTokenSet) {
        if (fileContent == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(4);
        }
        if (parserDefinition == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(5);
        }
        if (noWSRequireBeforeTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(6);
        }
        if (noWSRequireAfterTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(7);
        }
        if (stringsTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(8);
        }
        Lexer lexer = parserDefinition.createLexer(null);
        lexer.start(fileContent);
        if (!MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, stringsTokenSet)) {
            return false;
        }
        if (lexer.getTokenType() == null) {
            return true;
        }
        int startOffset = fileContent.length() - 400;
        if (startOffset <= 0) {
            return true;
        }
        while (lexer.getTokenType() != null && lexer.getTokenStart() < startOffset) {
            lexer.advance();
        }
        if (lexer.getTokenType() == null || fileContent.length() - lexer.getTokenStart() < 300) {
            return true;
        }
        return MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, stringsTokenSet);
    }

    protected static boolean isMinified(@NotNull Lexer lexer, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet, @NotNull TokenSet stringLiteralElements) {
        if (lexer == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(9);
        }
        if (parserDefinition == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(10);
        }
        if (noWSRequireBeforeTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(11);
        }
        if (noWSRequireAfterTokenSet == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(12);
        }
        if (stringLiteralElements == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(13);
        }
        int offsetIgnoringComments = 0;
        int offsetIgnoringCommentsAndStrings = 0;
        int unneededWhitespaceCount = 0;
        String lastTokenText = null;
        IElementType lastTokenType = null;
        TokenSet whitespaceTokens = parserDefinition.getWhitespaceTokens();
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        boolean lastWhiteSpaceWasHandled = false;
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            if (commentTokens.contains(tokenType)) {
                lastTokenType = tokenType;
                lastTokenText = lexer.getTokenText();
            } else {
                int tokenLength = lexer.getTokenEnd() - lexer.getTokenStart();
                if (!MinifiedFilesUtil.isNewLine(lexer, tokenLength) || !commentTokens.contains(lastTokenType) || noWSRequireAfterTokenSet.contains(lastTokenType)) {
                    offsetIgnoringComments += tokenLength;
                    if (!stringLiteralElements.contains(tokenType)) {
                        offsetIgnoringCommentsAndStrings += tokenLength;
                    }
                    if (whitespaceTokens.contains(tokenType)) {
                        lastWhiteSpaceWasHandled = false;
                        if (tokenLength > 1 && !commentTokens.contains(lastTokenType)) {
                            lexer.advance();
                            if (lexer.getTokenType() == null) break;
                            return false;
                        }
                        if (MinifiedFilesUtil.isNewLine(lexer, tokenLength) && StringUtil.equals((CharSequence)lastTokenText, (CharSequence)"\n") || tokenLength > 0 && noWSRequireAfterTokenSet.contains(lastTokenType)) {
                            ++unneededWhitespaceCount;
                            lastWhiteSpaceWasHandled = true;
                        }
                    } else if (!lastWhiteSpaceWasHandled && whitespaceTokens.contains(lastTokenType) && StringUtil.isNotEmpty((String)lastTokenText) && noWSRequireBeforeTokenSet.contains(tokenType)) {
                        ++unneededWhitespaceCount;
                    }
                    if (stringLiteralElements.contains(tokenType)) {
                        lastTokenType = tokenType;
                        lastTokenText = lexer.getTokenText();
                    } else {
                        if (offsetIgnoringComments >= 2048) break;
                        lastTokenType = tokenType;
                        lastTokenText = lexer.getTokenText();
                    }
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return offsetIgnoringComments >= 150 && ((double)unneededWhitespaceCount + 0.0) / (double)offsetIgnoringCommentsAndStrings < 0.01;
    }

    private static boolean isNewLine(@NotNull Lexer lexer, int tokenLength) {
        if (lexer == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(14);
        }
        return tokenLength == 1 && StringUtil.equals((CharSequence)lexer.getTokenText(), (CharSequence)"\n");
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition) {
        if (fileContent == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(15);
        }
        if (parserDefinition == null) {
            MinifiedFilesUtil.$$$reportNull$$$0(16);
        }
        return MinifiedFilesUtil.isMinified(fileContent, parserDefinition, TokenSet.EMPTY, TokenSet.EMPTY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noWSRequireBeforeTokenSet";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noWSRequireAfterTokenSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringsTokenSet";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/MinifiedFilesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMinified";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isNewLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

