/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternDialectProvider {
    public static final ExtensionPointName<PatternDialectProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.patternDialectProvider");

    public static PatternDialectProvider getInstance(String shortName) {
        for (PatternDialectProvider provider2 : EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual((String)provider2.getShortName(), (String)shortName)) continue;
            return provider2;
        }
        return "file".equals(shortName) ? null : PatternDialectProvider.getInstance("file");
    }

    public abstract TreeModel createTreeModel(Project var1, Marker var2);

    public abstract TreeModel createTreeModel(Project var1, Set<? extends PsiFile> var2, Marker var3, DependenciesPanel.DependencyPanelSettings var4);

    @Contract(pure=true)
    @NlsActions.ActionText
    public abstract String getDisplayName();

    @Contract(pure=true)
    @NonNls
    @NotNull
    public abstract String getShortName();

    public abstract AnAction[] createActions(Project var1, Runnable var2);

    @Nullable
    public abstract PackageSet createPackageSet(PackageDependenciesNode var1, boolean var2);

    @Nullable
    protected static String getModulePattern(PackageDependenciesNode node) {
        ModuleNode moduleParent = PatternDialectProvider.getModuleParent(node);
        return moduleParent != null ? moduleParent.getModuleName() : null;
    }

    @Nullable
    protected static ModuleNode getModuleParent(PackageDependenciesNode node) {
        if (node instanceof ModuleNode) {
            return (ModuleNode)node;
        }
        if (node == null || node instanceof RootNode) {
            return null;
        }
        return PatternDialectProvider.getModuleParent((PackageDependenciesNode)node.getParent());
    }

    public abstract Icon getIcon();

    @NotNull
    protected static String getGroupModulePattern(ModuleGroupNode node) {
        if (ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)node.getProject())) {
            String string = node.getModuleGroup().getQualifiedName() + "*";
            if (string == null) {
                PatternDialectProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "group:" + node.getModuleGroup().toString();
        if (string == null) {
            PatternDialectProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/PatternDialectProvider", "getGroupModulePattern"));
    }
}

