/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;

public class SquareStripeButtonUI
extends StripeButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new SquareStripeButtonUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new DimensionUIResource(26, 26);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g, JComponent c) {
        StripeButton button2 = (StripeButton)c;
        Icon icon2 = button2.toolWindow.getIcon();
        if (icon2 instanceof ScalableIcon) {
            icon2 = ((ScalableIcon)icon2).scale(1.4f);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            ButtonModel model2 = button2.getModel();
            if (model2.isArmed() && model2.isPressed() || model2.isSelected() || model2.isRollover()) {
                g2.setColor(model2.isSelected() ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR);
                g2.fillRect(0, 0, button2.getWidth(), button2.getHeight());
            }
            if (icon2 != null) {
                IconUtil.paintInCenterOf((Component)button2, (Graphics)g2, (Icon)icon2);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

