/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsData;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsState;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        PluginAdvertiserExtensionsState pluginAdvertiserExtensionsState = PluginAdvertiserExtensionsState.getInstance(project);
        String fullExtension = file2.getExtension() != null ? "*." + file2.getExtension() : null;
        PluginAdvertiserExtensionsData extensionsData = pluginAdvertiserExtensionsState.requestExtensionData(file2.getName(), file2.getFileType(), fullExtension);
        Set<String> jetBrainsPluginsIds = MarketplaceRequests.getInstance().getJetBrainsPluginsIds();
        if (extensionsData == null || jetBrainsPluginsIds == null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                MarketplaceRequests.getInstance().loadJetBrainsPluginsIds();
                boolean shouldUpdateNotifications = PluginAdvertiserExtensionsState.getInstance(project).updateCache(file2.getName());
                if (fullExtension != null) {
                    boolean bl = shouldUpdateNotifications = PluginAdvertiserExtensionsState.getInstance(project).updateCache(fullExtension) || shouldUpdateNotifications;
                }
                if (shouldUpdateNotifications) {
                    EditorNotifications.getInstance((Project)project).updateNotifications(file2);
                }
                LOG.debug(String.format("Tried to update extensions cache for file '%s'. shouldUpdateNotifications=%s", file2.getName(), shouldUpdateNotifications));
            });
            return null;
        }
        String extensionOrFileName = extensionsData.getExtensionOrFileName();
        Set<PluginsAdvertiser.Plugin> plugins = extensionsData.getPlugins();
        panel2.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])new Object[]{extensionOrFileName}));
        IdeaPluginDescriptor disabledPlugin = null;
        HashSet<PluginsAdvertiser.Plugin> pluginsToInstall = new HashSet<PluginsAdvertiser.Plugin>();
        HashSet<PluginsAdvertiser.Plugin> jbPluginsToInstall = new HashSet<PluginsAdvertiser.Plugin>();
        for (PluginsAdvertiser.Plugin plugin2 : plugins) {
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(PluginId.getId((String)plugin2.myPluginId));
            if (installedPlugin != null) {
                if (installedPlugin.isEnabled() || disabledPlugin != null) continue;
                disabledPlugin = installedPlugin;
                continue;
            }
            if (plugin2.myBundled) continue;
            pluginsToInstall.add(plugin2);
            if (!jetBrainsPluginsIds.contains(plugin2.myPluginId)) continue;
            jbPluginsToInstall.add(plugin2);
        }
        if (disabledPlugin != null) {
            IdeaPluginDescriptor finalDisabledPlugin = disabledPlugin;
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.enable.plugin", (Object[])new Object[]{disabledPlugin.getName()}), () -> {
                pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor").addData("plugins", Collections.singletonList(finalDisabledPlugin.getPluginId().getIdString()));
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "enable.plugins", data2);
                PluginsAdvertiser.enablePlugins(project, Collections.singletonList(finalDisabledPlugin.getPluginId()));
            });
        } else if (!jbPluginsToInstall.isEmpty()) {
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugins", (Object[])new Object[0]), () -> PluginAdvertiserEditorNotificationProvider.installPlugins(project, pluginAdvertiserExtensionsState, extensionOrFileName, jbPluginsToInstall));
        } else if (PluginsAdvertiser.hasBundledPluginToInstall(plugins) != null) {
            if (PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                return null;
            }
            panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])new Object[]{extensionOrFileName}));
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.try.ultimate", (Object[])new Object[0]), () -> {
                pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "open.download.page", data2);
                PluginsAdvertiser.openDownloadPage();
            });
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> {
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.ultimate", data2);
                PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        } else if (!pluginsToInstall.isEmpty()) {
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugins", (Object[])new Object[0]), () -> PluginAdvertiserEditorNotificationProvider.installPlugins(project, pluginAdvertiserExtensionsState, extensionOrFileName, pluginsToInstall));
        } else {
            return null;
        }
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.extension", (Object[])new Object[0]), () -> {
            FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
            FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.extensions", data2);
            pluginAdvertiserExtensionsState.ignoreExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel2;
    }

    private static void installPlugins(@NotNull Project project, PluginAdvertiserExtensionsState pluginAdvertiserExtensionsState, String extensionOrFileName, Set<PluginsAdvertiser.Plugin> pluginsToInstall) {
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        HashSet<PluginId> pluginIds = new HashSet<PluginId>();
        for (PluginsAdvertiser.Plugin plugin2 : pluginsToInstall) {
            pluginIds.add(PluginId.getId((String)plugin2.myPluginId));
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor").addData("plugins", ContainerUtil.map(pluginIds, pluginId -> pluginId.getIdString()));
        FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "install.plugins", data2);
        PluginsAdvertiser.installAndEnable(pluginIds, () -> {
            pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(extensionOrFileName);
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

