/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class OrderRootsCache {
    private final AtomicReference<ConcurrentMap<CacheKey, VirtualFilePointerContainer>> myRoots;
    private final Disposable myParentDisposable;
    private Disposable myRootsDisposable;
    private static final VirtualFilePointerContainer EMPTY = (VirtualFilePointerContainer)ObjectUtils.sentinel((String)"Empty roots container", VirtualFilePointerContainer.class);

    @ApiStatus.Internal
    public OrderRootsCache(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            OrderRootsCache.$$$reportNull$$$0(0);
        }
        this.myRoots = new AtomicReference();
        this.myParentDisposable = parentDisposable;
        this.disposePointers();
    }

    private void disposePointers() {
        if (this.myRootsDisposable != null) {
            Disposer.dispose((Disposable)this.myRootsDisposable);
        }
        if (!Disposer.isDisposed((Disposable)this.myParentDisposable)) {
            this.myRootsDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myRootsDisposable);
        }
    }

    private VirtualFilePointerContainer createContainer(@NotNull Collection<String> urls) {
        VirtualFilePointerContainer container;
        if (urls == null) {
            OrderRootsCache.$$$reportNull$$$0(1);
        }
        if (urls.isEmpty()) {
            container = EMPTY;
        } else {
            container = VirtualFilePointerManager.getInstance().createContainer(this.myRootsDisposable);
            ((VirtualFilePointerContainerImpl)container).addAll(urls);
        }
        return container;
    }

    private VirtualFilePointerContainer getOrComputeContainer(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> rootUrlsComputer) {
        VirtualFilePointerContainer cached;
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(2);
        }
        if (rootUrlsComputer == null) {
            OrderRootsCache.$$$reportNull$$$0(3);
        }
        ConcurrentMap map2 = this.myRoots.get();
        CacheKey key = new CacheKey(rootType, flags);
        VirtualFilePointerContainer virtualFilePointerContainer = cached = map2 == null ? null : (VirtualFilePointerContainer)map2.get(key);
        if (cached == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myRoots, new ConcurrentHashMap());
            cached = map2.computeIfAbsent(key, __ -> this.createContainer((Collection)rootUrlsComputer.get()));
        }
        return cached == EMPTY ? null : cached;
    }

    VirtualFile @NotNull [] getOrComputeRoots(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container;
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(4);
        }
        if (computer == null) {
            OrderRootsCache.$$$reportNull$$$0(5);
        }
        VirtualFile[] virtualFileArray = (container = this.getOrComputeContainer(rootType, flags, computer)) == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
        if (virtualFileArray == null) {
            OrderRootsCache.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    String @NotNull [] getOrComputeUrls(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container;
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(7);
        }
        if (computer == null) {
            OrderRootsCache.$$$reportNull$$$0(8);
        }
        String[] stringArray = (container = this.getOrComputeContainer(rootType, flags, computer)) == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container.getUrls();
        if (stringArray == null) {
            OrderRootsCache.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @ApiStatus.Internal
    public void clearCache() {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.disposePointers();
        this.myRoots.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrlsComputer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderRootsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootsCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrComputeRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrComputeUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeContainer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeRoots";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeUrls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CacheKey {
        private final OrderRootType myRootType;
        private final int myFlags;

        private CacheKey(@NotNull OrderRootType rootType, int flags) {
            if (rootType == null) {
                CacheKey.$$$reportNull$$$0(0);
            }
            this.myRootType = rootType;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.myFlags == cacheKey.myFlags && this.myRootType.equals((Object)cacheKey.myRootType);
        }

        public int hashCode() {
            return 31 * this.myRootType.hashCode() + this.myFlags;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/OrderRootsCache$CacheKey", "<init>"));
        }
    }
}

