/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnknownSdkEditorPanel
extends EditorNotificationPanel {
    private final AtomicBoolean myIsRunning;
    private static final Key<?> EDITOR_NOTIFICATIONS_KEY = Key.create((String)"SdkSetupNotificationNew");
    @NotNull
    private final UnknownSdkFix myFix;
    @Nullable
    private final UnknownSdkFixAction myAction;

    public UnknownSdkEditorPanel(final @NotNull Project project, @NotNull UnknownSdkFix fix) {
        if (project == null) {
            UnknownSdkEditorPanel.$$$reportNull$$$0(0);
        }
        if (fix == null) {
            UnknownSdkEditorPanel.$$$reportNull$$$0(1);
        }
        this.myIsRunning = new AtomicBoolean(false);
        this.myFix = fix;
        this.myAction = this.myFix.getSuggestedFixAction();
        this.setProject(project);
        this.setProviderKey(EDITOR_NOTIFICATIONS_KEY);
        this.setText(fix.getNotificationText());
        if (this.myAction != null) {
            HyperlinkLabel label2 = this.createActionLabel(this.myAction.getActionShortText(), () -> {
                if (!this.myIsRunning.compareAndSet(false, true)) {
                    return;
                }
                this.myAction.applySuggestionAsync(project);
            }, true);
            String tooltip = this.myAction.getActionTooltipText();
            if (tooltip != null) {
                label2.setToolTipText(tooltip);
            }
        }
        this.createActionLabel(this.myFix.getConfigureActionText(), new EditorNotificationPanel.ActionHandler(){
            private final EditorNotificationPanel.ActionHandler handler;
            {
                this.handler = UnknownSdkEditorPanel.this.myFix.getConfigureActionHandler(project);
            }

            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent event) {
                if (panel2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!UnknownSdkEditorPanel.this.myIsRunning.compareAndSet(false, true)) {
                    return;
                }
                this.handler.handlePanelActionClick(panel2, event);
            }

            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile psiFile) {
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!UnknownSdkEditorPanel.this.myIsRunning.compareAndSet(false, true)) {
                    return;
                }
                this.handler.handleQuickFixClick(editor, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true);
    }

    protected String getIntentionActionText() {
        UnknownSdkFixAction action2 = this.myFix.getSuggestedFixAction();
        if (action2 != null) {
            return action2.getActionShortText();
        }
        return this.myFix.getIntentionActionText();
    }

    @NotNull
    protected PriorityAction.Priority getIntentionActionPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.HIGH;
        if (priority == null) {
            UnknownSdkEditorPanel.$$$reportNull$$$0(2);
        }
        return priority;
    }

    @NotNull
    protected String getIntentionActionFamilyName() {
        String string = ProjectBundle.message((String)"config.unknown.sdk.configuration", (Object[])new Object[0]);
        if (string == null) {
            UnknownSdkEditorPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionPriority";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

