/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DumbServiceBalloon {
    private static final Logger LOG = Logger.getInstance(DumbServiceBalloon.class);
    @NotNull
    private static final JBInsets DUMB_BALLOON_INSETS = JBInsets.create((int)5, (int)8);
    private final Project myProject;
    private final Service myService;
    private Balloon myBalloon;

    public DumbServiceBalloon(@NotNull Project project, @NotNull Service service) {
        if (project == null) {
            DumbServiceBalloon.$$$reportNull$$$0(0);
        }
        if (service == null) {
            DumbServiceBalloon.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myService = service;
    }

    void dispose() {
        if (this.myBalloon != null) {
            Disposer.dispose((Disposable)this.myBalloon);
        }
    }

    void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonStillShowing) {
        if (balloonText == null) {
            DumbServiceBalloon.$$$reportNull$$$0(2);
        }
        if (runWhenSmartAndBalloonStillShowing == null) {
            DumbServiceBalloon.$$$reportNull$$$0(3);
        }
        if (LightEdit.owns((Project)this.myProject)) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myService.isDumb()) {
            UIEventLogger.DumbModeBalloonWasNotNeeded.log(this.myProject);
            runWhenSmartAndBalloonStillShowing.run();
            return;
        }
        if (this.myBalloon != null) {
            return;
        }
        this.tryShowBalloonTillSmartMode(balloonText, runWhenSmartAndBalloonStillShowing);
    }

    private void tryShowBalloonTillSmartMode(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonNotHidden) {
        if (balloonText == null) {
            DumbServiceBalloon.$$$reportNull$$$0(4);
        }
        if (runWhenSmartAndBalloonNotHidden == null) {
            DumbServiceBalloon.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.myBalloon == null);
        long startTimestamp = System.nanoTime();
        UIEventLogger.DumbModeBalloonRequested.log(this.myProject);
        this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonText, AllIcons.General.BalloonWarning, UIUtil.getToolTipBackground(), null).setBorderColor(JBColor.border()).setBorderInsets((Insets)DUMB_BALLOON_INSETS).setShowCallout(false).createBalloon();
        this.myBalloon.setAnimationEnabled(false);
        this.myBalloon.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DumbServiceBalloon.this.myBalloon == null) {
                    return;
                }
                UIEventLogger.DumbModeBalloonCancelled.log(DumbServiceBalloon.this.myProject);
                DumbServiceBalloon.this.myBalloon = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/project/DumbServiceBalloon$1", "onClosed"));
            }
        });
        this.myService.runWhenSmart(() -> {
            if (this.myBalloon == null) {
                return;
            }
            UIEventLogger.DumbModeBalloonProceededToActions.log(this.myProject, (Object)TimeoutUtil.getDurationMillis((long)startTimestamp));
            runWhenSmartAndBalloonNotHidden.run();
            Balloon balloon2 = this.myBalloon;
            this.myBalloon = null;
            balloon2.hide();
        });
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            if (!this.myService.isDumb()) {
                return;
            }
            if (this.myBalloon == null) {
                return;
            }
            UIEventLogger.DumbModeBalloonShown.log(this.myProject);
            this.myBalloon.show(DumbServiceBalloon.getDumbBalloonPopupPoint(this.myBalloon, context), Balloon.Position.above);
        });
    }

    @NotNull
    private static RelativePoint getDumbBalloonPopupPoint(@NotNull Balloon balloon2, DataContext context) {
        if (balloon2 == null) {
            DumbServiceBalloon.$$$reportNull$$$0(6);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        Dimension size = balloon2.getPreferredSize();
        Point point = relativePoint.getPoint();
        point.translate(size.width / 2, 0);
        point.translate(-DumbServiceBalloon.DUMB_BALLOON_INSETS.left - AllIcons.General.BalloonWarning.getIconWidth() - JBUIScale.scale((int)6), 0);
        return new RelativePoint(relativePoint.getComponent(), point);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloonText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhenSmartAndBalloonStillShowing";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhenSmartAndBalloonNotHidden";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceBalloon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showDumbModeActionBalloon";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryShowBalloonTillSmartMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDumbBalloonPopupPoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Service {
        public boolean isDumb();

        public void runWhenSmart(@NotNull Runnable var1);
    }
}

