/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.DetectedByContentFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class FileTypeDetectionService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileTypeDetectionService.class);
    private static final Key<String> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final AtomicInteger counterAutoDetect;
    private final AtomicLong elapsedAutoDetect;
    private static final int CHUNK_SIZE = 10;
    private static boolean RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
    private final Executor reDetectExecutor;
    private final HashSetQueue<VirtualFile> filesToRedetect;
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final ConcurrentPackedBitsArray packedFlags;
    private int cachedDetectFileBufferSize;
    private volatile boolean myRestrictCachedDetectedFileTypeAccess;
    private final FileTypeManagerImpl myFileTypeManager;

    FileTypeDetectionService(@NotNull FileTypeManagerImpl fileTypeManager) {
        if (fileTypeManager == null) {
            FileTypeDetectionService.$$$reportNull$$$0(0);
        }
        this.counterAutoDetect = new AtomicInteger();
        this.elapsedAutoDetect = new AtomicLong();
        this.reDetectExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileTypeManager Redetect Pool", (Executor)AppExecutorUtil.getAppExecutorService(), (int)1, (Disposable)this);
        this.filesToRedetect = new HashSetQueue();
        this.packedFlags = new ConcurrentPackedBitsArray(4);
        this.cachedDetectFileBufferSize = -1;
        this.myFileTypeManager = fileTypeManager;
        int fileTypeChangedCounter = PropertiesComponent.getInstance().getInt("fileTypeChangedCounter", 0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                final Set files2 = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered2;
                    ProgressManager.checkCanceled();
                    VirtualFile file2 = event instanceof VFileCreateEvent || this.isReparseEvent((VFileEvent)event) ? null : event.getFile();
                    VirtualFile virtualFile = filtered2 = file2 != null && FileTypeDetectionService.this.wasAutoDetectedBefore(file2) && FileTypeDetectionService.isDetectable(file2) ? file2 : null;
                    if (FileTypeDetectionService.this.toLog()) {
                        FileTypeDetectionService.this.log("F: after() VFS event " + event + "; filtered file: " + filtered2 + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeDetectionService.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeDetectionService.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeDetectionService.readableFlags(FileTypeDetectionService.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered2;
                });
                files2.remove(null);
                if (FileTypeDetectionService.this.toLog()) {
                    FileTypeDetectionService.this.log("F: after() VFS events: " + events + "; files: " + files2);
                }
                ProgressManager.checkCanceled();
                if (!files2.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeDetectionService.this.toLog()) {
                        FileTypeDetectionService.this.log("F: after() queued to redetect: " + files2);
                    }
                    for (VirtualFile file2 : files2) {
                        FileTypeDetectionService.this.ensureReDetected(file2);
                    }
                    if (!files2.isEmpty()) {
                        return new AsyncFileListener.ChangeApplier(){

                            public void beforeVfsChange() {
                                FileTypeDetectionService.this.myRestrictCachedDetectedFileTypeAccess = true;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void afterVfsChange() {
                                try {
                                    HashSetQueue<VirtualFile> hashSetQueue = FileTypeDetectionService.this.filesToRedetect;
                                    synchronized (hashSetQueue) {
                                        if (FileTypeDetectionService.this.filesToRedetect.addAll(files2)) {
                                            FileTypeDetectionService.this.awakeReDetectExecutor();
                                        }
                                    }
                                }
                                finally {
                                    FileTypeDetectionService.this.myRestrictCachedDetectedFileTypeAccess = false;
                                }
                            }
                        };
                    }
                }
                return null;
            }

            private boolean isReparseEvent(@NotNull VFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                return event instanceof VFilePropertyChangeEvent && "FileContentUtilCore.saveOrReload".equals(event.getRequestor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "prepareChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isReparseEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        FileTypeRegistry.FileTypeDetector.EP_NAME.addChangeListener(() -> {
            this.cachedDetectFileBufferSize = -1;
            this.clearCaches();
        }, (Disposable)this);
        Application app = ApplicationManager.getApplication();
        Disposer.register((Disposable)app, (Disposable)this);
    }

    private boolean toLog() {
        return this.myFileTypeManager.toLog;
    }

    private void log(String s) {
        this.myFileTypeManager.log(s);
    }

    @NotNull
    FileType getOrDetectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(1);
        }
        if (!FileTypeDetectionService.isDetectable(file2)) {
            if (this.myFileTypeManager.getFileTypeByFileName(file2.getName()) == DetectedByContentFileType.INSTANCE) {
                DetectedByContentFileType detectedByContentFileType = DetectedByContentFileType.INSTANCE;
                if (detectedByContentFileType == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(2);
                }
                return detectedByContentFileType;
            }
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                FileTypeDetectionService.$$$reportNull$$$0(3);
            }
            return fileType;
        }
        if (this.myRestrictCachedDetectedFileTypeAccess) {
            try {
                return this.detectFromContent(file2, content2);
            }
            catch (IOException e) {
                FileType fileType = UnknownFileType.INSTANCE;
                if (fileType == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(4);
                }
                return fileType;
            }
        }
        this.ensureReDetected(file2);
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id2 = ((VirtualFileWithId)file2).getId();
            long flags = this.packedFlags.get(id2);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id2, flags);
                if (this.toLog()) {
                    this.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeDetectionService.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeDetectionService.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    this.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType = type;
                    if (fileType == null) {
                        FileTypeDetectionService.$$$reportNull$$$0(5);
                    }
                    return fileType;
                }
            }
        }
        FileType fileType = this.getFileTypeDetectedFromContent(file2);
        if (this.toLog()) {
            this.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2, content2);
            }
            catch (IOException e) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            this.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(6);
        }
        return fileType2;
    }

    void loadState(@NotNull Element state) {
        if (state == null) {
            FileTypeDetectionService.$$$reportNull$$$0(7);
        }
        String fileTypeChangedCounterStr = null;
        for (Element element2 : state.getChildren()) {
            if (!element2.getName().equals("setting") || !"fileTypeChangedCounter".equals(element2.getAttributeValue("name"))) continue;
            fileTypeChangedCounterStr = element2.getAttributeValue("value");
            break;
        }
        if (fileTypeChangedCounterStr != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt(fileTypeChangedCounterStr, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        this.clearPersistentAttributes();
        if (this.toLog()) {
            this.log("F: clearCaches()");
        }
    }

    public void dispose() {
        LOG.info(String.format("%s auto-detected files. Detection took %s ms", this.counterAutoDetect, this.elapsedAutoDetect));
    }

    static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(8);
        }
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private byte readFlagsFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(9);
        }
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try (DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);){
            status = stream == null ? (byte)0 : stream.readByte();
            wasAutoDetectRun = stream != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    private void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(10);
        }
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            this.log("F: clearPersistentAttributes()");
        }
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            FileTypeDetectionService.$$$reportNull$$$0(12);
        }
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id2, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    this.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType.getName());
        if (this.toLog()) {
            this.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.execute(() -> {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i2 = 0; i2 < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i2) {
                    files2.add(file2);
                }
            }
            if (files2.size() == 10) {
                this.awakeReDetectExecutor();
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.reDetect(files2));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureReDetected(@NotNull VirtualFile file2) {
        boolean submitted;
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(13);
        }
        ProgressManager.checkCanceled();
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        synchronized (hashSetQueue) {
            submitted = this.filesToRedetect.remove((Object)file2);
        }
        if (submitted) {
            try {
                this.reDetect(Collections.singleton(file2));
            }
            catch (ProcessCanceledException e) {
                HashSetQueue<VirtualFile> hashSetQueue2 = this.filesToRedetect;
                synchronized (hashSetQueue2) {
                    this.filesToRedetect.offer((Object)file2);
                }
                throw e;
            }
        }
    }

    @Nullable
    private FileType getFileTypeDetectedFromContent(VirtualFile file2) {
        String fileTypeName = (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        return fileTypeName == null ? null : this.myFileTypeManager.findFileTypeByName(fileTypeName);
    }

    private void reDetect(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(14);
        }
        if (files2.isEmpty()) {
            return;
        }
        ArrayList<VirtualFile> changed2 = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            FileType after2;
            FileType before;
            block11: {
                if (this.toLog()) {
                    this.log("F: reDetect(" + virtualFile.getName() + ") " + virtualFile.getName());
                }
                int id2 = ((VirtualFileWithId)virtualFile).getId();
                long flags = this.packedFlags.get(id2);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeDetectionService.textOrBinaryFromCachedFlags(flags), (Object)((FileType)ObjectUtils.notNull((Object)this.getFileTypeDetectedFromContent(virtualFile), (Object)((Object)PlainTextFileType.INSTANCE))));
                after2 = this.myFileTypeManager.getByFile(virtualFile);
                if (this.toLog()) {
                    this.log("F: reDetect(" + virtualFile.getName() + ") prepare to redetect. flags: " + FileTypeDetectionService.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after2 == null ? null : after2.getName()));
                }
                if (after2 == null || FileTypeManagerImpl.mightBeReplacedByDetectedFileType(after2)) {
                    try {
                        after2 = this.detectFromContentAndCache(virtualFile, null);
                        break block11;
                    }
                    catch (IOException e) {
                        crashed.add(virtualFile);
                        if (!this.toLog()) continue;
                        this.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                virtualFile.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id2, flags);
            }
            if (this.toLog()) {
                this.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: " + after2.getName() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after2) continue;
            changed2.add(virtualFile);
        }
        if (!changed2.isEmpty()) {
            FileTypeDetectionService.reparseLater(changed2);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeDetectionService.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(15);
        }
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            return (this.packedFlags.get(id2) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(16);
        }
        long start2 = System.currentTimeMillis();
        FileType fileType = this.detectFromContent(file2, content2);
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(17);
        }
        return fileType2;
    }

    private int readSafely(@NotNull InputStream stream, byte @NotNull [] buffer, int length) throws IOException {
        int n;
        if (stream == null) {
            FileTypeDetectionService.$$$reportNull$$$0(18);
        }
        if (buffer == null) {
            FileTypeDetectionService.$$$reportNull$$$0(19);
        }
        if ((n = stream.read(buffer, 0, length)) <= 0) {
            if (this.toLog()) {
                this.log("F: processFirstBytes(): inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeDetectionService.streamInfo(stream));
            }
            n = (Integer)ReadAction.compute(() -> stream.read(buffer, 0, length));
            if (this.toLog()) {
                this.log("F: processFirstBytes(): under read action inputStream.read() returned " + n + "; stream=" + FileTypeDetectionService.streamInfo(stream));
            }
        }
        return n;
    }

    @NotNull
    private FileType detectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        FileType fileType;
        block18: {
            if (file2 == null) {
                FileTypeDetectionService.$$$reportNull$$$0(20);
            }
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            if (content2 != null) {
                fileType = this.detect(file2, content2, content2.length, detectors);
            } else {
                try (InputStream inputStream2 = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                    if (this.toLog()) {
                        this.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeDetectionService.streamInfo(inputStream2));
                    }
                    int fileLength = (int)file2.getLength();
                    int bufferLength = this.getDetectFileBufferSize();
                    byte[] buffer = fileLength <= 20480 ? FileUtilRt.getThreadLocalBuffer() : new byte[Math.min(fileLength, bufferLength)];
                    int n = this.readSafely(inputStream2, buffer, buffer.length);
                    fileType = this.detect(file2, buffer, n, detectors);
                    if (!this.toLog()) break block18;
                    try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                        byte[] buffer2 = new byte[50];
                        int n2 = newStream.read(buffer2, 0, buffer2.length);
                        this.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + fileType.getName() + "; stream: " + FileTypeDetectionService.streamInfo(inputStream2) + "; newStream: " + FileTypeDetectionService.streamInfo(newStream) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer2));
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(21);
        }
        return fileType2;
    }

    @NotNull
    private FileType detect(@NotNull VirtualFile file2, byte @NotNull [] bytes, int length, @NotNull List<? extends FileTypeRegistry.FileTypeDetector> detectors) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(22);
        }
        if (detectors == null) {
            FileTypeDetectionService.$$$reportNull$$$0(23);
        }
        if (bytes == null) {
            FileTypeDetectionService.$$$reportNull$$$0(24);
        }
        if (length <= 0) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                FileTypeDetectionService.$$$reportNull$$$0(25);
            }
            return fileType;
        }
        FileType fileType = LoadTextUtil.processTextFromBinaryPresentationOrNull(bytes, length, file2, true, true, (FileType)PlainTextFileType.INSTANCE, (NotNullFunction<? super CharSequence, ? extends FileType>)((NotNullFunction)text2 -> {
            if (this.toLog()) {
                this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): bytes length=" + length + "; isText=" + (text2 != null) + "; text='" + (text2 == null ? null : StringUtil.first((CharSequence)text2, (int)100, (boolean)true)) + "', detectors=" + detectors);
            }
            Object detected = null;
            ByteArraySequence firstBytes = new ByteArraySequence(bytes, 0, length);
            for (FileTypeRegistry.FileTypeDetector detector : detectors) {
                try {
                    detected = detector.detect(file2, (ByteSequence)firstBytes, text2);
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") threw PCE. Bad detector, bad!", (Throwable)new RuntimeException(e));
                }
                catch (Exception e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!this.toLog()) break;
                this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + detector + " type as " + detected.getName());
                break;
            }
            if (detected == null && text2 != null) {
                detected = (FileType)this.myFileTypeManager.myPatternsTable.findAssociatedFileTypeByHashBang(text2);
            }
            if (detected == null) {
                Object object = detected = text2 == null ? UnknownFileType.INSTANCE : PlainTextFileType.INSTANCE;
                if (this.toLog()) {
                    this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            return detected;
        }));
        if (fileType == null) {
            FileTypeDetectionService.$$$reportNull$$$0(26);
        }
        return fileType;
    }

    private int getDetectFileBufferSize() {
        int bufferLength = this.cachedDetectFileBufferSize;
        if (bufferLength == -1) {
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            for (int i2 = 0; i2 < detectors.size(); ++i2) {
                FileTypeRegistry.FileTypeDetector detector = (FileTypeRegistry.FileTypeDetector)detectors.get(i2);
                bufferLength = Math.max(bufferLength, detector.getDesiredContentPrefixLength());
            }
            if (bufferLength <= 0) {
                bufferLength = FileUtilRt.getUserContentLoadLimit();
            }
            this.cachedDetectFileBufferSize = bufferLength;
        }
        return bufferLength;
    }

    @NotNull
    private static String readableFlags(long flags) {
        Object result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = (String)result2 + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        Object object = result2;
        if (object == null) {
            FileTypeDetectionService.$$$reportNull$$$0(27);
        }
        return object;
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    private static void reparseLater(@NotNull List<? extends VirtualFile> changed2) {
        if (changed2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)changed2), ApplicationManager.getApplication().getDisposed());
    }

    @NonNls
    private static Object streamInfo(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileTypeDetectionService.$$$reportNull$$$0(29);
        }
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeDetectionService.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel2 = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel2 + ", channel.size=" + (channel2 == null ? null : Long.valueOf(channel2.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    @TestOnly
    void drainReDetectQueue() {
        try {
            ((BoundedTaskExecutor)this.reDetectExecutor).waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        // MONITORENTER : hashSetQueue
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        // MONITOREXIT : hashSetQueue
        if (arrayList != null) return arrayList;
        FileTypeDetectionService.$$$reportNull$$$0(30);
        return arrayList;
    }

    @TestOnly
    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectors";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetectFromContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContentAndCache";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "readableFlags";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrDetectFromContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDetectable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readFlagsFromCache";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeFlagsToCache";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cacheAutoDetectedFileType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureReDetected";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reDetect";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wasAutoDetectedBefore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContentAndCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readSafely";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContent";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "reparseLater";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "streamInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

