/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.toolbar.floating.VisibilityController$WhenMappings;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H$J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H$J\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004H$R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController;", "Lcom/intellij/openapi/Disposable;", "()V", "autoHide", "", "getAutoHide", "()Z", "isDisposed", "opacity", "", "getOpacity", "()F", "opacityCounter", "", "retentionTimer", "Ljavax/swing/Timer;", "Lorg/jetbrains/annotations/NotNull;", "state", "Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController$State;", "transitionTimer", "dispose", "", "isRetention", "propagateStateChanges", "refresh", "repaint", "scheduleHide", "scheduleShow", "setVisible", "isVisible", "Companion", "State", "intellij.platform.ide.impl"})
public abstract class VisibilityController
implements Disposable {
    private boolean isDisposed;
    private int opacityCounter;
    private State state = State.INVISIBLE;
    private final Timer transitionTimer;
    private final Timer retentionTimer;
    private static final int RETENTION_DELAY = 1500;
    private static final int TRANSITION_DELAY = 50;
    private static final int TRANSITION_VALUE = 20;
    private static final int MAX_VALUE = 100;
    private static final int MIN_VALUE = 0;
    public static final Companion Companion = new Companion(null);

    protected abstract boolean getAutoHide();

    protected abstract void setVisible(boolean var1);

    protected abstract void repaint();

    protected abstract boolean isRetention();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getOpacity() {
        float f;
        VisibilityController visibilityController = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (visibilityController) {
            boolean bl3 = false;
            f = (float)this.opacityCounter / 100.0f;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleHide() {
        VisibilityController visibilityController = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (visibilityController) {
            State state;
            boolean bl3 = false;
            switch (VisibilityController$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    state = State.INVISIBLE;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    state = State.HIDING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.state = state;
            this.propagateStateChanges();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleShow() {
        VisibilityController visibilityController = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (visibilityController) {
            State state;
            boolean bl3 = false;
            switch (VisibilityController$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
                case 1: {
                    state = State.VISIBLE;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    state = State.SHOWING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.state = state;
            this.propagateStateChanges();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refresh() {
        VisibilityController visibilityController = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (visibilityController) {
            boolean bl3 = false;
            switch (VisibilityController$WhenMappings.$EnumSwitchMapping$2[this.state.ordinal()]) {
                case 1: {
                    this.opacityCounter -= 20;
                    break;
                }
                case 2: {
                    this.opacityCounter += 20;
                    break;
                }
            }
            int n = this.opacityCounter;
            int n2 = 100;
            boolean bl4 = false;
            n = this.opacityCounter = Math.min(n, n2);
            n2 = 0;
            bl4 = false;
            this.opacityCounter = Math.max(n, n2);
            switch (this.opacityCounter) {
                case 100: {
                    this.state = State.VISIBLE;
                    break;
                }
                case 0: {
                    this.state = State.INVISIBLE;
                }
            }
            this.propagateStateChanges();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void propagateStateChanges() {
        if (this.isDisposed) {
            return;
        }
        switch (VisibilityController$WhenMappings.$EnumSwitchMapping$3[this.state.ordinal()]) {
            case 1: 
            case 2: {
                this.transitionTimer.stop();
                break;
            }
            case 3: 
            case 4: {
                this.transitionTimer.start();
                break;
            }
        }
        switch (VisibilityController$WhenMappings.$EnumSwitchMapping$4[this.state.ordinal()]) {
            case 1: {
                if (!this.getAutoHide()) break;
                this.retentionTimer.restart();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.retentionTimer.stop();
                break;
            }
        }
        switch (VisibilityController$WhenMappings.$EnumSwitchMapping$5[this.state.ordinal()]) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setVisible(true);
                break;
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        VisibilityController visibilityController = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (visibilityController) {
            boolean bl3 = false;
            this.isDisposed = true;
            this.transitionTimer.stop();
            this.retentionTimer.stop();
            Unit unit = Unit.INSTANCE;
        }
    }

    public VisibilityController() {
        Timer timer2 = TimerUtil.createNamedTimer((String)"Transition timer", (int)50);
        Intrinsics.checkNotNullExpressionValue((Object)timer2, (String)"TimerUtil.createNamedTim\u2026timer\", TRANSITION_DELAY)");
        this.transitionTimer = timer2;
        Timer timer3 = TimerUtil.createNamedTimer((String)"Retention timer", (int)1500);
        Intrinsics.checkNotNullExpressionValue((Object)timer3, (String)"TimerUtil.createNamedTim\u2026 timer\", RETENTION_DELAY)");
        this.retentionTimer = timer3;
        this.retentionTimer.setRepeats(false);
        this.retentionTimer.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                if (this.isRetention()) {
                    this.scheduleShow();
                } else {
                    this.scheduleHide();
                }
            }
        });
        this.transitionTimer.setRepeats(true);
        this.transitionTimer.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.refresh();
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController$State;", "", "(Ljava/lang/String;I)V", "INVISIBLE", "VISIBLE", "HIDING", "SHOWING", "intellij.platform.ide.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State INVISIBLE;
        public static final /* enum */ State VISIBLE;
        public static final /* enum */ State HIDING;
        public static final /* enum */ State SHOWING;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[4];
            State[] stateArray2 = stateArray;
            stateArray[0] = INVISIBLE = new State();
            stateArray[1] = VISIBLE = new State();
            stateArray[2] = HIDING = new State();
            stateArray[3] = SHOWING = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController$Companion;", "", "()V", "MAX_VALUE", "", "MIN_VALUE", "RETENTION_DELAY", "TRANSITION_DELAY", "TRANSITION_VALUE", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

