/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.IntPair;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class IndentsModelImpl
implements IndentsModel {
    private final Map<IntPair, IndentGuideDescriptor> myIndentsByLines;
    private List<IndentGuideDescriptor> myIndents;
    @NotNull
    private final EditorImpl myEditor;

    public IndentsModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            IndentsModelImpl.$$$reportNull$$$0(0);
        }
        this.myIndentsByLines = CollectionFactory.createSmallMemoryFootprintMap();
        this.myIndents = new ArrayList<IndentGuideDescriptor>();
        this.myEditor = editor;
    }

    @NotNull
    public List<IndentGuideDescriptor> getIndents() {
        List<IndentGuideDescriptor> list2 = this.myIndents;
        if (list2 == null) {
            IndentsModelImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public IndentGuideDescriptor getCaretIndentGuide() {
        LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
        int column = pos.column;
        int line = pos.line;
        if (column > 0) {
            for (IndentGuideDescriptor indent : this.myIndents) {
                if (column != indent.indentLevel || line < indent.startLine || line >= indent.endLine) continue;
                return indent;
            }
        }
        return null;
    }

    public IndentGuideDescriptor getDescriptor(int startLine, int endLine) {
        return this.myIndentsByLines.get(new IntPair(startLine, endLine));
    }

    public void assumeIndents(@NotNull List<IndentGuideDescriptor> descriptors2) {
        if (descriptors2 == null) {
            IndentsModelImpl.$$$reportNull$$$0(2);
        }
        this.myIndents = descriptors2;
        this.myIndentsByLines.clear();
        for (IndentGuideDescriptor descriptor2 : this.myIndents) {
            this.myIndentsByLines.put(new IntPair(descriptor2.startLine, descriptor2.endLine), descriptor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/IndentsModelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/IndentsModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assumeIndents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

