/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private final PsiModificationTracker myModificationTracker;
    private long myModificationCount;

    protected ProjectViewPsiTreeChangeListener(@NotNull Project project) {
        if (project == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = PsiManager.getInstance((Project)project).getModificationTracker();
        this.myModificationCount = this.myModificationTracker.getModificationCount();
    }

    protected abstract AbstractTreeUpdater getUpdater();

    protected abstract boolean isFlattenPackages();

    protected abstract DefaultMutableTreeNode getRootNode();

    public final void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiElement child2;
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(1);
        }
        if ((child2 = event.getOldChild()) instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiElement child2;
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(2);
        }
        if ((child2 = event.getNewChild()) instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(3);
        }
        PsiElement oldChild = event.getOldChild();
        PsiElement newChild = event.getNewChild();
        if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(4);
        }
        this.childrenChanged(event.getOldParent(), false);
        this.childrenChanged(event.getNewParent(), true);
    }

    public final void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(5);
        }
        this.childrenChanged(event.getParent(), true);
    }

    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
        if (parent instanceof PsiDirectory && this.isFlattenPackages()) {
            this.addSubtreeToUpdateByRoot();
            return;
        }
        long newModificationCount = this.myModificationTracker.getModificationCount();
        if (newModificationCount == this.myModificationCount) {
            return;
        }
        if (stopProcessingForThisModificationCount) {
            this.myModificationCount = newModificationCount;
        }
        while (parent != null) {
            if (parent instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)parent).getVirtualFile();
                if (virtualFile != null && virtualFile.getFileType() != FileTypes.PLAIN_TEXT && (parent = ((PsiFile)parent).getContainingDirectory()) == null) {
                    break;
                }
            } else if (parent instanceof PsiDirectory && ScratchUtil.isScratch(((PsiDirectory)parent).getVirtualFile())) {
                this.addSubtreeToUpdateByRoot();
                break;
            }
            if (this.addSubtreeToUpdateByElementFile(parent) || parent instanceof PsiFile || parent instanceof PsiDirectory) break;
            parent = parent.getParent();
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(6);
        }
        String propertyName = event.getPropertyName();
        PsiElement element2 = event.getElement();
        if (propertyName.equals("roots")) {
            this.addSubtreeToUpdateByRoot();
        } else if (propertyName.equals("writable")) {
            if (!this.addSubtreeToUpdateByElementFile(element2) && element2 instanceof PsiFile) {
                this.addSubtreeToUpdateByElementFile((PsiElement)((PsiFile)element2).getContainingDirectory());
            }
        } else if (propertyName.equals("fileName") || propertyName.equals("directoryName")) {
            if (element2 instanceof PsiDirectory && this.isFlattenPackages()) {
                this.addSubtreeToUpdateByRoot();
                return;
            }
            PsiElement parent = element2.getParent();
            if (parent == null || !this.addSubtreeToUpdateByElementFile(parent)) {
                this.addSubtreeToUpdateByElementFile(element2);
            }
        } else if (propertyName.equals("propFileTypes") || propertyName.equals("propUnloadedPsi")) {
            this.addSubtreeToUpdateByRoot();
        }
    }

    protected void addSubtreeToUpdateByRoot() {
        AbstractTreeUpdater updater = this.getUpdater();
        DefaultMutableTreeNode root = this.getRootNode();
        if (updater != null && root != null) {
            updater.addSubtreeToUpdate(root);
        }
    }

    protected boolean addSubtreeToUpdateByElement(@NotNull PsiElement element2) {
        AbstractTreeUpdater updater;
        if (element2 == null) {
            ProjectViewPsiTreeChangeListener.$$$reportNull$$$0(7);
        }
        return (updater = this.getUpdater()) != null && updater.addSubtreeToUpdateByElement((Object)element2);
    }

    private boolean addSubtreeToUpdateByElementFile(PsiElement element2) {
        return element2 != null && this.addSubtreeToUpdateByElement((PsiElement)ObjectUtils.notNull((Object)element2.getContainingFile(), (Object)element2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSubtreeToUpdateByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

