/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginChunkDataSource;
import com.intellij.ide.plugins.marketplace.PluginChunkMerger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import com.jetbrains.plugin.blockmap.core.FileHash;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010(\u001a\u00020\u0018J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010*\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J*\u0010.\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00063"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService;", "", "()V", "BLOCKMAP_FILENAME", "", "BLOCKMAP_ZIP_SUFFIX", "FILENAME", "HASH_FILENAME_SUFFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAXIMUM_DOWNLOAD_PERCENT", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "downloadPercent", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "downloadPlugin", "Ljava/io/File;", "pluginUrl", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginViaBlockMap", "prevPlugin", "Ljava/nio/file/Path;", "getBlockMapFromZip", "input", "Ljava/io/InputStream;", "getPluginFileUrl", "connection", "Ljava/net/URLConnection;", "getPluginFileUrlAndGuessFileParameters", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService$GuessFileParameters;", "getPluginTempFile", "getPrevPluginArchive", "guessFileName", "contentDisposition", "usedURL", "file", "guessPluginFile", "url", "renameFileToZipRoot", "zip", "GuessFileParameters", "intellij.platform.ide.impl"})
public final class MarketplacePluginDownloadService {
    private static final Logger LOG;
    private static final String BLOCKMAP_ZIP_SUFFIX = ".blockmap.zip";
    private static final String BLOCKMAP_FILENAME = "blockmap.json";
    private static final String HASH_FILENAME_SUFFIX = ".hash.json";
    private static final String FILENAME = "filename=";
    private static final double MAXIMUM_DOWNLOAD_PERCENT = 0.65;
    private static final Lazy objectMapper$delegate;
    public static final MarketplacePluginDownloadService INSTANCE;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = objectMapper$delegate;
        MarketplacePluginDownloadService marketplacePluginDownloadService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public final File downloadPlugin(@NotNull String pluginUrl, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        File file2 = this.getPluginTempFile();
        Object object = HttpRequests.request((String)pluginUrl).gzip(false).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(file2, indicator, pluginUrl){
            final /* synthetic */ File $file;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ String $pluginUrl;

            public final File process(@NotNull HttpRequests.Request request) {
                File file2;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                request.saveToFile(this.$file, this.$indicator);
                URLConnection uRLConnection = request.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"request.connection");
                String pluginFileUrl = MarketplacePluginDownloadService.access$getPluginFileUrl(MarketplacePluginDownloadService.INSTANCE, uRLConnection);
                if (StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null)) {
                    file2 = MarketplacePluginDownloadService.INSTANCE.renameFileToZipRoot(this.$file);
                } else {
                    String contentDisposition = request.getConnection().getHeaderField("Content-Disposition");
                    URLConnection uRLConnection2 = request.getConnection();
                    Intrinsics.checkNotNullExpressionValue((Object)uRLConnection2, (String)"request.connection");
                    String string = uRLConnection2.getURL().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.connection.url.toString()");
                    String url = string;
                    file2 = MarketplacePluginDownloadService.access$guessPluginFile(MarketplacePluginDownloadService.INSTANCE, contentDisposition, url, this.$file, this.$pluginUrl);
                }
                return file2;
            }
            {
                this.$file = file2;
                this.$indicator = progressIndicator;
                this.$pluginUrl = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(plu\u2026inUrl)\n        }\n      })");
        return (File)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final File downloadPluginViaBlockMap(@NotNull String pluginUrl, @NotNull Path prevPlugin, @NotNull ProgressIndicator indicator) throws IOException {
        void pluginFileUrl;
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)prevPlugin, (String)"prevPlugin");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path prevPluginArchive = this.getPrevPluginArchive(prevPlugin);
        if (!PathKt.exists((Path)prevPluginArchive)) {
            LOG.info(IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{((Object)prevPluginArchive).toString()}));
            return this.downloadPlugin(pluginUrl, indicator);
        }
        Pair<String, GuessFileParameters> pair = this.getPluginFileUrlAndGuessFileParameters(pluginUrl);
        String string = (String)pair.component1();
        GuessFileParameters guessFileParameters = (GuessFileParameters)pair.component2();
        String blockMapFileUrl = (String)pluginFileUrl + BLOCKMAP_ZIP_SUFFIX;
        String pluginHashFileUrl = (String)pluginFileUrl + HASH_FILENAME_SUFFIX;
        try {
            FileHash fileHash;
            boolean $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22;
            Object[] input2;
            BlockMap newBlockMap2 = (BlockMap)HttpRequests.request((String)blockMapFileUrl).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)downloadPluginViaBlockMap.newBlockMap.1.INSTANCE);
            LOG.info("Plugin's blockmap file downloaded");
            FileHash newPluginHash2 = (FileHash)HttpRequests.request((String)pluginHashFileUrl).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)downloadPluginViaBlockMap.newPluginHash.1.INSTANCE);
            LOG.info("Plugin's hash file downloaded");
            Closeable closeable = new FileInputStream(prevPluginArchive.toFile());
            boolean bl = false;
            boolean bl2 = false;
            Object object = null;
            try {
                input2 = (Object[])closeable;
                $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = false;
                input2 = new BlockMap((InputStream)input2, newBlockMap2.getAlgorithm(), newBlockMap2.getMinSize(), newBlockMap2.getMaxSize(), newBlockMap2.getNormalSize());
            }
            catch (Throwable input2) {
                object = input2;
                throw input2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object[] oldBlockMap = input2;
            BlockMap blockMap = newBlockMap2;
            Intrinsics.checkNotNullExpressionValue((Object)blockMap, (String)"newBlockMap");
            double downloadPercent = this.downloadPercent((BlockMap)oldBlockMap, blockMap);
            object = "Plugin's download percent is = %.2f";
            input2 = new Object[]{downloadPercent * (double)100};
            $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = false;
            String string2 = String.format((String)object, Arrays.copyOf(input2, input2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            LOG.info(string2);
            if (downloadPercent > 0.65) {
                throw (Throwable)new IOException(IdeBundle.message((String)"too.large.download.size", (Object[])new Object[0]));
            }
            File file2 = this.getPluginTempFile();
            File file3 = prevPluginArchive.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"prevPluginArchive.toFile()");
            PluginChunkMerger merger = new PluginChunkMerger(file3, (BlockMap)oldBlockMap, newBlockMap2, indicator);
            Closeable $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = new FileOutputStream(file2);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)$i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22;
                boolean bl5 = false;
                merger.merge(output, new PluginChunkDataSource((BlockMap)oldBlockMap, newBlockMap2, (String)pluginFileUrl));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22, (Throwable)throwable);
            }
            Closeable closeable2 = new FileInputStream(file2);
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = null;
            try {
                FileInputStream input3 = (FileInputStream)closeable2;
                boolean bl8 = false;
                fileHash = new FileHash((InputStream)input3, newPluginHash2.getAlgorithm());
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
            }
            FileHash curFileHash = fileHash;
            if (Intrinsics.areEqual((Object)curFileHash, (Object)newPluginHash2) ^ true) {
                throw (Throwable)new IOException(IdeBundle.message((String)"hashes.doesnt.match", (Object[])new Object[0]));
            }
            return StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null) ? this.renameFileToZipRoot(file2) : this.guessPluginFile(guessFileParameters.getContentDisposition(), guessFileParameters.getUrl(), file2, pluginUrl);
        }
        catch (Exception e) {
            LOG.info(IdeBundle.message((String)"error.download.plugin.via.blockmap", (Object[])new Object[0]), (Throwable)e);
            return this.downloadPlugin((String)pluginFileUrl, indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BlockMap getBlockMapFromZip(InputStream input) throws IOException {
        BlockMap blockMap;
        Closeable closeable = input;
        int n = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BlockMap blockMap2;
            BufferedInputStream source = (BufferedInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new ZipInputStream(source);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable2 = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable2;
                boolean bl5 = false;
                ZipEntry entry = zip.getNextEntry();
                while (true) {
                    ZipEntry zipEntry = entry;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"entry");
                    if (!(Intrinsics.areEqual((Object)zipEntry.getName(), (Object)BLOCKMAP_FILENAME) ^ true) || entry.getName() == null) break;
                    entry = zip.getNextEntry();
                }
                if (!Intrinsics.areEqual((Object)entry.getName(), (Object)BLOCKMAP_FILENAME)) {
                    throw (Throwable)new IOException("There is no entry blockmap.json");
                }
                blockMap2 = (BlockMap)INSTANCE.getObjectMapper().readValue(ByteStreamsKt.readBytes((InputStream)zip), BlockMap.class);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            BlockMap blockMap3 = blockMap2;
            blockMap = blockMap3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)blockMap, (String)"input.buffered().use { s\u2026)\n        }\n      }\n    }");
        return blockMap;
    }

    private final File guessPluginFile(String contentDisposition, String url, File file2, String pluginUrl) {
        String fileName = this.guessFileName(contentDisposition, url, file2, pluginUrl);
        File newFile = new File(file2.getParentFile(), fileName);
        FileUtil.rename((File)file2, (File)newFile);
        return newFile;
    }

    private final String guessFileName(String contentDisposition, String usedURL, File file2, String pluginUrl) throws IOException {
        String fileName = null;
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && StringsKt.contains$default((CharSequence)contentDisposition, (CharSequence)FILENAME, (boolean)false, (int)2, null)) {
            int startIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (String)FILENAME, (int)0, (boolean)false, (int)6, null);
            int endIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (char)';', (int)startIdx, (boolean)false, (int)4, null);
            String string = contentDisposition;
            int n = startIdx + FILENAME.length();
            int n2 = endIdx > 0 ? endIdx : contentDisposition.length();
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            fileName = string2;
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                string = fileName;
                n = 1;
                n2 = fileName.length() - 1;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                fileName = string4;
            }
        }
        if (fileName == null) {
            LOG.debug("url: " + usedURL);
            CharSequence charSequence = usedURL;
            int n = StringsKt.lastIndexOf$default((CharSequence)usedURL, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            fileName = string5;
            charSequence = fileName;
            n = 0;
            if (charSequence.length() == 0 || StringsKt.contains$default((CharSequence)fileName, (CharSequence)"?", (boolean)false, (int)2, null)) {
                charSequence = pluginUrl;
                n = StringsKt.lastIndexOf$default((CharSequence)pluginUrl, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string6;
            }
        }
        if (!PathUtil.isValidFileName((String)fileName)) {
            LOG.debug("fileName: " + fileName);
            FileUtil.delete((File)file2);
            throw (Throwable)new IOException("Invalid filename returned by a server");
        }
        return fileName;
    }

    @NotNull
    public final File renameFileToZipRoot(@NotNull File zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        String newName2 = PluginInstaller.rootEntryName(zip.toPath()) + ".zip";
        File newZip = new File(zip.getParent() + '/' + newName2);
        if (newZip.exists()) {
            FileUtil.delete((File)newZip);
        }
        FileUtil.rename((File)zip, (String)newName2);
        return newZip;
    }

    /*
     * WARNING - void declaration
     */
    private final double downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap2) {
        int n;
        Chunk chunk;
        void $this$filterTo$iv$iv;
        Set oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable $this$filter$iv = newBlockMap2.getChunks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk2 = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!oldSet.contains(chunk2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newChunks = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = newChunks;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Chunk chunk3 = (Chunk)element$iv;
            int n2 = sum$iv;
            boolean bl = false;
            int n3 = chunk.getLength();
            sum$iv = n2 + n3;
        }
        $this$sumBy$iv = newBlockMap2.getChunks();
        double d = sum$iv;
        $i$f$sumBy = false;
        sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            chunk = (Chunk)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n4 = chunk.getLength();
            sum$iv = n + n4;
        }
        n = sum$iv;
        return d / (double)n;
    }

    private final String getPluginFileUrl(URLConnection connection) {
        URL url;
        URL uRL = url = connection.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
        int port = uRL.getPort();
        return port == -1 ? url.getProtocol() + "://" + url.getHost() + url.getPath() : url.getProtocol() + "://" + url.getHost() + ':' + port + url.getPath();
    }

    private final Pair<String, GuessFileParameters> getPluginFileUrlAndGuessFileParameters(String pluginUrl) {
        Object object = HttpRequests.request((String)pluginUrl).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)getPluginFileUrlAndGuessFileParameters.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(plu\u2026on.url.toString()))\n    }");
        return (Pair)object;
    }

    private final Path getPrevPluginArchive(Path prevPlugin) {
        String suffix = prevPlugin.endsWith(".jar") ? "" : ".zip";
        Path path = Paths.get(PathManager.getPluginTempPath(), new String[0]).resolve(prevPlugin.getFileName() + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026Plugin.fileName}$suffix\")");
        return path;
    }

    @NotNull
    public final File getPluginTempFile() throws IOException {
        File pluginsTemp = new File(PathManager.getPluginTempPath());
        if (!pluginsTemp.exists() && !pluginsTemp.mkdirs()) {
            throw (Throwable)new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026\"_download\", true, false)");
        return file2;
    }

    private MarketplacePluginDownloadService() {
    }

    static {
        MarketplacePluginDownloadService marketplacePluginDownloadService;
        INSTANCE = marketplacePluginDownloadService = new MarketplacePluginDownloadService();
        Logger logger = Logger.getInstance(MarketplacePluginDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Marke\u2026nloadService::class.java)");
        LOG = logger;
        objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    }

    public static final /* synthetic */ String access$getPluginFileUrl(MarketplacePluginDownloadService $this, URLConnection connection) {
        return $this.getPluginFileUrl(connection);
    }

    public static final /* synthetic */ File access$guessPluginFile(MarketplacePluginDownloadService $this, String contentDisposition, String url, File file2, String pluginUrl) {
        return $this.guessPluginFile(contentDisposition, url, file2, pluginUrl);
    }

    public static final /* synthetic */ BlockMap access$getBlockMapFromZip(MarketplacePluginDownloadService $this, InputStream input) {
        return $this.getBlockMapFromZip(input);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(MarketplacePluginDownloadService $this) {
        return $this.getObjectMapper();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService$GuessFileParameters;", "", "contentDisposition", "", "url", "(Ljava/lang/String;Ljava/lang/String;)V", "getContentDisposition", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class GuessFileParameters {
        @Nullable
        private final String contentDisposition;
        @NotNull
        private final String url;

        @Nullable
        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public GuessFileParameters(@Nullable String contentDisposition, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.contentDisposition = contentDisposition;
            this.url = url;
        }

        @Nullable
        public final String component1() {
            return this.contentDisposition;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final GuessFileParameters copy(@Nullable String contentDisposition, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new GuessFileParameters(contentDisposition, url);
        }

        public static /* synthetic */ GuessFileParameters copy$default(GuessFileParameters guessFileParameters, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = guessFileParameters.contentDisposition;
            }
            if ((n & 2) != 0) {
                string2 = guessFileParameters.url;
            }
            return guessFileParameters.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GuessFileParameters(contentDisposition=" + this.contentDisposition + ", url=" + this.url + ")";
        }

        public int hashCode() {
            String string = this.contentDisposition;
            String string2 = this.url;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GuessFileParameters)) break block3;
                    GuessFileParameters guessFileParameters = (GuessFileParameters)object;
                    if (!Intrinsics.areEqual((Object)this.contentDisposition, (Object)guessFileParameters.contentDisposition) || !Intrinsics.areEqual((Object)this.url, (Object)guessFileParameters.url)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

