/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="ProjectPluginTrackerManager", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/ProjectPluginTrackerManager;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/ide/plugins/ProjectPluginTrackerManager$Companion$ProjectPluginTrackerManagerState;", "()V", "applicationShuttingDown", "", "createPluginTracker", "Lcom/intellij/ide/plugins/ProjectPluginTracker;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
public final class ProjectPluginTrackerManager
extends SimplePersistentStateComponent<Companion.ProjectPluginTrackerManagerState> {
    private boolean applicationShuttingDown;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ProjectPluginTracker createPluginTracker(@NotNull Project project) {
        ProjectPluginTracker.Companion.ProjectPluginTrackerState projectPluginTrackerState;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String workspaceId = project.isDefault() ? null : ProjectKt.getStateStore(project).getProjectWorkspaceId();
        String string = workspaceId;
        if (string == null) {
            String string2 = project.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.name");
        }
        String key = string;
        Project project2 = project;
        Map<String, ProjectPluginTracker.Companion.ProjectPluginTrackerState> $this$getOrPut$iv = ((Companion.ProjectPluginTrackerManagerState)this.getState()).getTrackers();
        boolean $i$f$getOrPut = false;
        ProjectPluginTracker.Companion.ProjectPluginTrackerState value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            Project project3 = project2;
            boolean bl = false;
            ProjectPluginTracker.Companion.ProjectPluginTrackerState projectPluginTrackerState2 = new ProjectPluginTracker.Companion.ProjectPluginTrackerState();
            project2 = project3;
            ProjectPluginTracker.Companion.ProjectPluginTrackerState answer$iv = projectPluginTrackerState2;
            $this$getOrPut$iv.put(key, answer$iv);
            projectPluginTrackerState = answer$iv;
        } else {
            projectPluginTrackerState = value$iv;
        }
        ProjectPluginTracker.Companion.ProjectPluginTrackerState projectPluginTrackerState3 = projectPluginTrackerState;
        Project project4 = project2;
        return new ProjectPluginTracker(project4, projectPluginTrackerState3);
    }

    public ProjectPluginTrackerManager() {
        super((BaseState)new Companion.ProjectPluginTrackerManagerState());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026on().messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (applicationShuttingDown) {
                    return;
                }
                this.createPluginTracker(project).updatePluginEnabledState$intellij_platform_ide_impl(false);
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                applicationShuttingDown = true;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final ProjectPluginTrackerManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final ProjectPluginTracker createPluginTrackerOrNull(@Nullable Project project) {
        return Companion.createPluginTrackerOrNull(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/plugins/ProjectPluginTrackerManager$Companion;", "", "()V", "createPluginTrackerOrNull", "Lcom/intellij/ide/plugins/ProjectPluginTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lcom/intellij/ide/plugins/ProjectPluginTrackerManager;", "ProjectPluginTrackerManagerState", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectPluginTrackerManager getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(ProjectPluginTrackerManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (ProjectPluginTrackerManager)((Object)object);
        }

        @JvmStatic
        @Nullable
        public final ProjectPluginTracker createPluginTrackerOrNull(@Nullable Project project) {
            ProjectPluginTracker projectPluginTracker;
            Project project2 = project;
            if (project2 != null) {
                Project project3 = project2;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project3;
                boolean bl3 = false;
                projectPluginTracker = Companion.getInstance().createPluginTracker(it);
            } else {
                projectPluginTracker = null;
            }
            return projectPluginTracker;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002RC\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/plugins/ProjectPluginTrackerManager$Companion$ProjectPluginTrackerManagerState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "", "Lcom/intellij/ide/plugins/ProjectPluginTracker$Companion$ProjectPluginTrackerState;", "trackers", "getTrackers", "()Ljava/util/Map;", "setTrackers", "(Ljava/util/Map;)V", "trackers$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.ide.impl"})
        public static final class ProjectPluginTrackerManagerState
        extends BaseState {
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            @NotNull
            private final ReadWriteProperty trackers$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ProjectPluginTrackerManagerState.class, "trackers", "getTrackers()Ljava/util/Map;", 0))};
            }

            @XCollection
            @NotNull
            public final Map<String, ProjectPluginTracker.Companion.ProjectPluginTrackerState> getTrackers() {
                return (Map)this.trackers$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            public final void setTrackers(@NotNull Map<String, ProjectPluginTracker.Companion.ProjectPluginTrackerState> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
                this.trackers$delegate.setValue((Object)this, $$delegatedProperties[0], map2);
            }
        }
    }
}

