/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PluginManager {
    public static final String INSTALLED_TXT = "installed.txt";
    private final List<Runnable> disabledPluginListeners = new CopyOnWriteArrayList<Runnable>();

    @NotNull
    public static PluginManager getInstance() {
        PluginManager pluginManager = (PluginManager)ApplicationManager.getApplication().getService(PluginManager.class);
        if (pluginManager == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        return pluginManager;
    }

    private PluginManager() {
        DisabledPluginsState.setDisabledPluginListener(() -> {
            for (Runnable listener2 : this.disabledPluginListeners) {
                listener2.run();
            }
        });
    }

    public void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        this.disabledPluginListeners.add(listener2);
    }

    public void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        this.disabledPluginListeners.remove(listener2);
    }

    @Nullable
    public static Path getOnceInstalledIfExists() {
        Path onceInstalledFile = PathManager.getConfigDir().resolve(INSTALLED_TXT);
        return Files.isRegularFile(onceInstalledFile, new LinkOption[0]) ? onceInstalledFile : null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull String fileName) {
        if (file2 == null) {
            PluginManager.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            PluginManager.$$$reportNull$$$0(4);
        }
        return PluginManager.loadDescriptor(file2, fileName, DisabledPluginsState.disabledPlugins(), false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull String fileName, @NotNull Set<PluginId> disabledPlugins, boolean bundled, PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        if (file2 == null) {
            PluginManager.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            PluginManager.$$$reportNull$$$0(6);
        }
        if (disabledPlugins == null) {
            PluginManager.$$$reportNull$$$0(7);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(disabledPlugins);
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, bundled, false, pathResolver);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file2, fileName, context, Files.isDirectory(file2, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Deprecated
    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            PluginManager.$$$reportNull$$$0(8);
        }
        try {
            Class<?> aClass = PluginManager.class.getClassLoader().loadClass("com.intellij.ide.plugins.StartupAbortedException");
            Method method2 = aClass.getMethod("processException", Throwable.class);
            method2.setAccessible(true);
            method2.invoke(null, t);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        return PluginManagerCore.getPlugin(id2);
    }

    public static IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        if (ideaPluginDescriptorArray == null) {
            PluginManager.$$$reportNull$$$0(9);
        }
        return ideaPluginDescriptorArray;
    }

    public static boolean isPluginInstalled(PluginId id2) {
        return PluginManagerCore.isPluginInstalled(id2);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(10);
        }
        return PluginManagerCore.getPluginByClassName(className);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<? extends IdeaPluginDescriptor> list2 = PluginManagerCore.getLoadedPlugins();
        if (list2 == null) {
            PluginManager.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    public PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(12);
        }
        return PluginManagerCore.getPluginOrPlatformByClassName(className);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        List<String> list2 = DisabledPluginsState.getDisabledPlugins();
        if (list2 == null) {
            PluginManager.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Deprecated
    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        if (ids == null) {
            PluginManager.$$$reportNull$$$0(14);
        }
        DisabledPluginsState.saveDisabledPlugins(ContainerUtil.map(ids, PluginId::getId), append);
    }

    public static boolean disablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManager.$$$reportNull$$$0(15);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManager.$$$reportNull$$$0(16);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    public boolean enablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManager.$$$reportNull$$$0(17);
        }
        return PluginManagerCore.enablePlugin(id2);
    }

    @ApiStatus.Internal
    @NotNull
    public static Logger getLogger() {
        Logger logger = PluginManagerCore.getLogger();
        if (logger == null) {
            PluginManager.$$$reportNull$$$0(18);
        }
        return logger;
    }

    @ApiStatus.Internal
    public static void loadDescriptorFromFile(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Path file2, @Nullable SafeJdomFactory factory2, @NotNull Set<PluginId> disabledPlugins) throws IOException, JDOMException {
        if (descriptor2 == null) {
            PluginManager.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            PluginManager.$$$reportNull$$$0(20);
        }
        if (disabledPlugins == null) {
            PluginManager.$$$reportNull$$$0(21);
        }
        int flags = 6;
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(flags, disabledPlugins, PluginManagerCore.createLoadingResult(null));
        descriptor2.readExternal(JDOMUtil.load((Path)file2, (SafeJdomFactory)factory2), PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, parentContext, descriptor2);
    }

    public boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin2) {
        if (plugin2 == null) {
            PluginManager.$$$reportNull$$$0(22);
        }
        return this.isDevelopedByJetBrains(plugin2.getVendor());
    }

    public boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (vendorString.equals("JetBrains") || vendorString.equals("JetBrains s.r.o.")) {
            return true;
        }
        for (String vendor : StringUtil.split((String)vendorString, (String)",")) {
            String vendorItem = vendor.trim();
            if (!"JetBrains".equals(vendorItem) && !"JetBrains s.r.o.".equals(vendorItem)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IdeaPluginDescriptor findEnabledPlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManager.$$$reportNull$$$0(23);
        }
        List<IdeaPluginDescriptorImpl> result2 = PluginManagerCore.getLoadedPlugins(null);
        for (IdeaPluginDescriptor ideaPluginDescriptor : result2) {
            if (id2 != ideaPluginDescriptor.getPluginId()) continue;
            return ideaPluginDescriptor;
        }
        return null;
    }

    public boolean hideImplementationDetails() {
        return !Registry.is((String)"plugins.show.implementation.details");
    }

    @ApiStatus.Internal
    public void setPlugins(@NotNull List<IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManager.$$$reportNull$$$0(24);
        }
        IdeaPluginDescriptorImpl[] list2 = descriptors2.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        PluginManagerCore.doSetPlugins(list2);
    }

    public boolean processAllBackwardDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<? super IdeaPluginDescriptor, FileVisitResult> consumer2) {
        if (rootDescriptor == null) {
            PluginManager.$$$reportNull$$$0(25);
        }
        if (consumer2 == null) {
            PluginManager.$$$reportNull$$$0(26);
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        Collection<IdeaPluginDescriptorImpl> allPlugins = PluginManagerCore.getAllPlugins();
        for (IdeaPluginDescriptorImpl plugin2 : allPlugins) {
            idMap.put(plugin2.getPluginId(), plugin2);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> semiGraph = PluginManagerCore.createPluginIdGraph(allPlugins, idMap::get, withOptionalDeps, PluginManagerCore.findPluginByModuleDependency(PluginManagerCore.ALL_MODULES_MARKER) != null);
        Graph graph2 = GraphGenerator.generate(semiGraph);
        LinkedHashSet dependencies = new LinkedHashSet();
        GraphAlgorithms.getInstance().collectOutsRecursively(graph2, (Object)rootDescriptor, dependencies);
        for (IdeaPluginDescriptorImpl dependency : dependencies) {
            if (dependency == rootDescriptor || consumer2.apply(dependency) != FileVisitResult.TERMINATE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor) {
        ClassLoader classLoader;
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(27);
        }
        if (!((classLoader = requestor.getClassLoader()) instanceof PluginAwareClassLoader)) {
            Disposable disposable2 = Disposer.newDisposable();
            if (disposable2 == null) {
                PluginManager.$$$reportNull$$$0(28);
            }
            return disposable2;
        }
        final int classLoaderId = ((PluginAwareClassLoader)classLoader).getInstanceId();
        return new PluginAwareDisposable(){

            @Override
            public int getClassLoaderId() {
                return classLoaderId;
            }

            public void dispose() {
            }
        };
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor, @NotNull ComponentManager parentDisposable) {
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(29);
        }
        if (parentDisposable == null) {
            PluginManager.$$$reportNull$$$0(30);
        }
        Disposable disposable2 = this.createDisposable(requestor);
        Disposer.register((Disposable)parentDisposable, (Disposable)disposable2);
        Disposable disposable3 = disposable2;
        if (disposable3 == null) {
            PluginManager.$$$reportNull$$$0(31);
        }
        return disposable3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findEnabledPlugin";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processAllBackwardDependencies";
                break;
            }
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDisposable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PluginAwareDisposable
    extends Disposable {
        public int getClassLoaderId();
    }
}

