/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginEnabler {
    private static final Logger LOG = Logger.getInstance(PluginEnabler.class);

    private PluginEnabler() {
    }

    public static boolean enablePlugins(@Nullable Project project, @NotNull List<? extends IdeaPluginDescriptor> plugins, boolean enable) {
        if (plugins == null) {
            PluginEnabler.$$$reportNull$$$0(0);
        }
        return PluginEnabler.updatePluginEnabledState(project, enable ? plugins : Collections.emptyList(), enable ? Collections.emptyList() : plugins, null, true);
    }

    public static boolean updatePluginEnabledState(@Nullable Project project, @NotNull List<? extends IdeaPluginDescriptor> pluginsToEnable, @NotNull List<? extends IdeaPluginDescriptor> pluginsToDisable, @Nullable JComponent parentComponent, boolean updateDisabledPluginsState) {
        boolean requiresRestart;
        if (pluginsToEnable == null) {
            PluginEnabler.$$$reportNull$$$0(1);
        }
        if (pluginsToDisable == null) {
            PluginEnabler.$$$reportNull$$$0(2);
        }
        if (pluginsToEnable.isEmpty() && pluginsToDisable.isEmpty()) {
            return true;
        }
        Set<PluginId> pluginIdsToEnable = PluginEnabler.mapPluginId(pluginsToEnable);
        LOG.info(PluginEnabler.getLogMessage(pluginIdsToEnable, true));
        PluginEnabler.updateEnabledState(pluginsToEnable, __ -> true);
        Set<PluginId> pluginIdsToDisable = PluginEnabler.mapPluginId(pluginsToDisable);
        LOG.info(PluginEnabler.getLogMessage(pluginIdsToDisable, false));
        PluginEnabler.updateEnabledState(pluginsToDisable, updateDisabledPluginsState ? __ -> false : PluginEnabler.getEnabledState(project));
        boolean bl = requiresRestart = updateDisabledPluginsState && !DisabledPluginsState.updateDisabledPluginsState(pluginIdsToEnable, pluginIdsToDisable) || !DynamicPlugins.loadUnloadPlugins(pluginsToEnable, pluginsToDisable, project, parentComponent);
        if (requiresRestart) {
            InstalledPluginsState.getInstance().setRestartRequired(true);
        }
        return !requiresRestart;
    }

    @NotNull
    public static Set<PluginId> mapPluginId(@NotNull List<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginEnabler.$$$reportNull$$$0(3);
        }
        Set<PluginId> set2 = descriptors2.stream().map(PluginDescriptor::getPluginId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set2 == null) {
            PluginEnabler.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    private static Predicate<PluginId> getEnabledState(@Nullable Project project) {
        ProjectPluginTrackerManager manager = ProjectPluginTrackerManager.getInstance();
        Predicate<PluginId> predicate = pluginId -> Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(openProject2 -> !openProject2.equals(project)).map(manager::createPluginTracker).anyMatch(pluginTracker -> pluginTracker.isEnabled((PluginId)pluginId));
        if (predicate == null) {
            PluginEnabler.$$$reportNull$$$0(5);
        }
        return predicate;
    }

    private static void updateEnabledState(@NotNull List<? extends IdeaPluginDescriptor> descriptors2, @NotNull Predicate<PluginId> predicate) {
        if (descriptors2 == null) {
            PluginEnabler.$$$reportNull$$$0(6);
        }
        if (predicate == null) {
            PluginEnabler.$$$reportNull$$$0(7);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            boolean enabled = predicate.test(ideaPluginDescriptor.getPluginId());
            ideaPluginDescriptor.setEnabled(enabled);
        }
    }

    @NotNull
    private static String getLogMessage(@NotNull Collection<PluginId> plugins, boolean enable) {
        if (plugins == null) {
            PluginEnabler.$$$reportNull$$$0(8);
        }
        return PluginEnabler.getLogMessage("Plugins to " + (enable ? "enable" : "disable"), plugins);
    }

    @NotNull
    public static String getLogMessage(@NotNull String message, @NotNull Collection<PluginId> plugins) {
        if (message == null) {
            PluginEnabler.$$$reportNull$$$0(9);
        }
        if (plugins == null) {
            PluginEnabler.$$$reportNull$$$0(10);
        }
        StringBuilder buffer = new StringBuilder(message).append(':').append(' ').append('[');
        StringUtil.join(plugins, PluginId::getIdString, (String)", ", (StringBuilder)buffer);
        String string = buffer.append(']').toString();
        if (string == null) {
            PluginEnabler.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToEnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToDisable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginEnabler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginEnabler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPluginId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginEnabledState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mapPluginId";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateEnabledState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLogMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

