/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    protected final List<IdeaPluginDescriptor> view = new ArrayList<IdeaPluginDescriptor>();
    private final Map<PluginId, PluginEnabledState> myEnabled = new HashMap<PluginId, PluginEnabledState>();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>();
    @Nullable
    private final Project myProject;
    @Nullable
    private final ProjectPluginTracker myPluginTracker;

    public InstalledPluginsTableModel(@Nullable Project project) {
        this.myProject = project;
        this.myPluginTracker = ProjectPluginTrackerManager.createPluginTrackerOrNull(this.myProject);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin2 : PluginManagerCore.getPlugins()) {
            PluginId pluginId = plugin2.getPluginId();
            if (appInfo.isEssentialPlugin(pluginId)) {
                this.myEnabled.put(pluginId, PluginEnabledState.ENABLED);
                continue;
            }
            this.view.add(plugin2);
        }
        this.view.addAll(ourState.getInstalledPlugins());
        for (IdeaPluginDescriptor descriptor2 : this.view) {
            this.setEnabled(descriptor2);
        }
        this.updatePluginDependencies();
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    @Nullable
    protected final ProjectPluginTracker getPluginTracker() {
        return this.myPluginTracker;
    }

    @NotNull
    protected List<IdeaPluginDescriptor> getAllPlugins() {
        return new ArrayList<IdeaPluginDescriptor>(this.view);
    }

    @Nullable
    public Set<PluginId> getRequiredPlugins(PluginId pluginId) {
        return this.myDependentToRequiredListMap.get(pluginId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRequiredPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(0);
        }
        if (this.myProject == null) return false;
        if (!ExternalDependenciesManager.getInstance(this.myProject).getDependencies(DependencyOnPlugin.class).stream().map(DependencyOnPlugin::getPluginId).anyMatch(descriptor2.getPluginId().getIdString()::equals)) return false;
        return true;
    }

    public final boolean isLoaded(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(1);
        }
        return InstalledPluginsTableModel.isLoaded(pluginId, this.getEnabledMap());
    }

    protected final void setEnabled(@NotNull IdeaPluginDescriptor ideaPluginDescriptor) {
        if (ideaPluginDescriptor == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(2);
        }
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        PluginEnabledState enabled = this.myPluginTracker != null && this.myPluginTracker.isEnabled(pluginId) ? PluginEnabledState.ENABLED_FOR_PROJECT : (this.myPluginTracker != null && this.myPluginTracker.isDisabled(pluginId) ? PluginEnabledState.DISABLED_FOR_PROJECT : (PluginManagerCore.isDisabled(pluginId) ? PluginEnabledState.DISABLED : (ideaPluginDescriptor.isEnabled() ? PluginEnabledState.ENABLED : null)));
        this.setEnabled(pluginId, enabled);
    }

    protected final void setEnabled(@NotNull PluginId pluginId, @Nullable PluginEnabledState enabled) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(3);
        }
        this.myEnabled.put(pluginId, enabled);
    }

    public Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.myDependentToRequiredListMap;
    }

    protected void updatePluginDependencies() {
        this.myDependentToRequiredListMap.clear();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = null;
        for (IdeaPluginDescriptor rootDescriptor : this.view) {
            PluginId pluginId = rootDescriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)rootDescriptor).isDeleted() || this.isDisabled(pluginId)) continue;
            if (pluginIdMap == null) {
                pluginIdMap = PluginManagerCore.buildPluginIdMap();
            }
            boolean loaded = this.isLoaded(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl) {
                PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, false, pluginIdMap, (depId, descriptor2) -> {
                    if (depId.equals(pluginId)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.isLoaded((PluginId)depId) && !ourState.wasInstalled((PluginId)depId) && !ourState.wasUpdated((PluginId)depId) && !ourState.wasInstalledWithoutRestart((PluginId)depId) || this.isDisabled((PluginId)depId)) {
                        Set<PluginId> required = this.myDependentToRequiredListMap.get(pluginId);
                        if (required == null) {
                            required = new HashSet<PluginId>();
                            this.myDependentToRequiredListMap.put(pluginId, required);
                        }
                        required.add((PluginId)depId);
                    }
                    return FileVisitResult.CONTINUE;
                });
            }
            if (loaded || this.myDependentToRequiredListMap.containsKey(pluginId) || !PluginManagerCore.isCompatible(rootDescriptor)) continue;
            this.setEnabled(pluginId, PluginEnabledState.ENABLED);
        }
    }

    protected final void enableRows(@NotNull Set<? extends IdeaPluginDescriptor> ideaPluginDescriptors, @NotNull PluginEnabledState newState2) {
        if (ideaPluginDescriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(4);
        }
        if (newState2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(5);
        }
        HashMap<PluginId, PluginEnabledState> tempEnabled = new HashMap<PluginId, PluginEnabledState>(this.myEnabled);
        InstalledPluginsTableModel.setNewEnabled(ideaPluginDescriptors, tempEnabled, newState2);
        if (this.suggestToChangeDependencies(ideaPluginDescriptors, tempEnabled, newState2)) {
            this.setNewEnabled(ideaPluginDescriptors, newState2);
            this.updatePluginDependencies();
        }
    }

    private void setNewEnabled(@NotNull Set<? extends IdeaPluginDescriptor> descriptors2, @NotNull PluginEnabledState newState2) {
        if (descriptors2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(6);
        }
        if (newState2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(7);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            this.handleBeforeChangeEnableState(ideaPluginDescriptor, newState2);
        }
        InstalledPluginsTableModel.setNewEnabled(descriptors2, this.myEnabled, newState2);
    }

    private static void setNewEnabled(@NotNull Set<? extends IdeaPluginDescriptor> ideaPluginDescriptors, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull PluginEnabledState newState2) {
        if (ideaPluginDescriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(8);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(9);
        }
        if (newState2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(10);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
            PluginId currentPluginId;
            enabledMap.put(currentPluginId, InstalledPluginsTableModel.isLoaded(currentPluginId = ideaPluginDescriptor.getPluginId(), enabledMap) ? newState2 : PluginEnabledState.DISABLED);
        }
    }

    public boolean isEnabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(11);
        }
        return !InstalledPluginsTableModel.isDisabled(pluginId, this.myEnabled);
    }

    public boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(12);
        }
        return !InstalledPluginsTableModel.isEnabled(pluginId, this.myEnabled);
    }

    @NotNull
    protected final Map<PluginId, PluginEnabledState> getEnabledMap() {
        Map<PluginId, PluginEnabledState> map2 = this.myEnabled;
        if (map2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(13);
        }
        return map2;
    }

    private boolean suggestToChangeDependencies(@NotNull Set<? extends IdeaPluginDescriptor> descriptorsWithChangedEnabledState, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull PluginEnabledState newState2) {
        boolean enabled;
        if (descriptorsWithChangedEnabledState == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(14);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(15);
        }
        if (newState2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(16);
        }
        ArrayList<? extends IdeaPluginDescriptor> descriptorsToCheckDependencies = new ArrayList<IdeaPluginDescriptor>((enabled = newState2.isEnabled()) ? descriptorsWithChangedEnabledState : this.getAllPlugins());
        if (!enabled) {
            descriptorsToCheckDependencies.removeAll(descriptorsWithChangedEnabledState);
            descriptorsToCheckDependencies.removeIf(descriptor2 -> InstalledPluginsTableModel.isDisabled(descriptor2.getPluginId(), enabledMap));
        }
        HashSet deps = new HashSet();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptorsToCheckDependencies) {
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            IdeaPluginDescriptorImpl pluginDescriptor2 = (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
            PluginManagerCore.processAllDependencies(pluginDescriptor2, false, pluginIdMap, (depId, descriptor2) -> {
                if (depId == pluginDescriptor2.getPluginId()) {
                    return FileVisitResult.CONTINUE;
                }
                if (!this.isLoaded((PluginId)depId)) {
                    return FileVisitResult.TERMINATE;
                }
                if (enabled && this.isDisabled((PluginId)depId) && descriptor2 != null) {
                    deps.add(descriptor2);
                }
                if (enabled || pluginDescriptor2.isDeleted() || pluginDescriptor2.isImplementationDetail()) {
                    return FileVisitResult.CONTINUE;
                }
                for (IdeaPluginDescriptor d : descriptorsWithChangedEnabledState) {
                    if (depId != d.getPluginId()) continue;
                    deps.add(pluginDescriptor2);
                    break;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        if (deps.isEmpty()) {
            return true;
        }
        String listOfDependencies = StringUtil.join(deps, pluginDescriptor -> {
            PluginId pluginId = pluginDescriptor.getPluginId();
            return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + (pluginId != null ? pluginId.getIdString() : pluginDescriptor.getName());
        }, (String)"<br>");
        int n = descriptorsWithChangedEnabledState.size();
        String message = enabled ? IdeBundle.message((String)"dialog.message.enable.required.plugins", (Object[])new Object[]{n, deps.size(), listOfDependencies}) : IdeBundle.message((String)"dialog.message.disable.dependent.plugins", (Object[])new Object[]{deps.size(), n, listOfDependencies});
        int dialogMessage = Messages.showOkCancelDialog((String)message, (String)(enabled ? IdeBundle.message((String)"dialog.title.enable.required.plugins", (Object[])new Object[0]) : IdeBundle.message((String)"dialog.title.disable.dependent.plugins", (Object[])new Object[0])), (String)(enabled ? IdeBundle.message((String)"button.enable", (Object[])new Object[0]) : IdeBundle.message((String)"button.disable", (Object[])new Object[0])), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
        if (dialogMessage == 0) {
            this.setNewEnabled(deps, newState2);
            return true;
        }
        return false;
    }

    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginEnabledState newState2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(17);
        }
        if (newState2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(18);
        }
    }

    protected static boolean isEnabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState enabled;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(19);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(20);
        }
        return (enabled = enabledMap.get(pluginId)) == null || enabled.isEnabled();
    }

    protected static boolean isDisabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState enabled;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(21);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(22);
        }
        return (enabled = enabledMap.get(pluginId)) == null || !enabled.isEnabled();
    }

    protected static boolean isLoaded(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(23);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(24);
        }
        return enabledMap.get(pluginId) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptors";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 9: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsWithChangedEnabledState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRequiredPlugin";
                break;
            }
            case 1: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLoaded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableRows";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNewEnabled";
                break;
            }
            case 11: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 12: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestToChangeDependencies";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

