/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassLoaderConfigurator {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static final boolean SEPARATE_CLASSLOADER_FOR_SUB = Boolean.parseBoolean(System.getProperty("idea.classloader.per.descriptor", "false"));
    private final boolean usePluginClassLoader;
    private final ClassLoader coreLoader;
    private final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    private final Map<String, String[]> additionalLayoutMap;
    private Optional<IdeaPluginDescriptorImpl> javaDep;
    private final Set<ClassLoader> loaders;
    private final boolean hasAllModules;
    private final UrlClassLoader.Builder urlClassLoaderBuilder;

    ClassLoaderConfigurator(boolean usePluginClassLoader, @NotNull ClassLoader coreLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<String, String[]> additionalLayoutMap) {
        if (coreLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(0);
        }
        if (idMap == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(1);
        }
        if (additionalLayoutMap == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(2);
        }
        this.loaders = new LinkedHashSet<ClassLoader>();
        this.usePluginClassLoader = usePluginClassLoader;
        this.coreLoader = coreLoader;
        this.idMap = idMap;
        this.additionalLayoutMap = additionalLayoutMap;
        this.hasAllModules = idMap.containsKey(PluginManagerCore.ALL_MODULES_MARKER);
        this.urlClassLoaderBuilder = UrlClassLoader.build().allowLock().useCache().urlsInterned();
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(3);
        }
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    void configure(@NotNull IdeaPluginDescriptorImpl mainDependent) {
        void var5_9;
        List<Path> classPath;
        IdeaPluginDescriptorImpl implicitDependency;
        if (mainDependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(4);
        }
        if (mainDependent.getPluginId() == PluginManagerCore.CORE_ID || mainDependent.isUseCoreClassLoader()) {
            ClassLoaderConfigurator.setPluginClassLoaderForMainAndSubPlugins(mainDependent, this.coreLoader);
            return;
        }
        if (!this.usePluginClassLoader) {
            ClassLoaderConfigurator.setPluginClassLoaderForMainAndSubPlugins(mainDependent, null);
        }
        this.loaders.clear();
        if (this.hasAllModules && (implicitDependency = PluginManagerCore.getImplicitDependency(mainDependent, () -> {
            if (this.javaDep == null) {
                this.javaDep = Optional.ofNullable(this.idMap.get(PluginManagerCore.JAVA_PLUGIN_ID));
            }
            return this.javaDep.orElse(null);
        })) != null) {
            this.addLoaderOrLogError(mainDependent, implicitDependency, this.loaders);
        }
        if ((classPath = mainDependent.jarFiles) == null) {
            classPath = mainDependent.collectClassPath(this.additionalLayoutMap);
        } else {
            mainDependent.jarFiles = null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (Path path : classPath) {
            urls.add(ClassLoaderConfigurator.localFileToUrl(path, mainDependent));
        }
        this.urlClassLoaderBuilder.urls(urls);
        List<PluginDependency> pluginDependencies = mainDependent.pluginDependencies;
        if (pluginDependencies == null) {
            assert (!mainDependent.isUseIdeaClassLoader());
            mainDependent.setClassLoader((ClassLoader)((Object)new PluginClassLoader(this.urlClassLoaderBuilder, this.loaders.toArray(EMPTY_CLASS_LOADER_ARRAY), (PluginDescriptor)mainDependent, mainDependent.getPluginPath(), this.coreLoader)));
            return;
        }
        for (PluginDependency dependency : pluginDependencies) {
            IdeaPluginDescriptorImpl dependencyDescriptor;
            if (dependency.isDisabledOrBroken || SEPARATE_CLASSLOADER_FOR_SUB && dependency.subDescriptor != null || (dependencyDescriptor = this.idMap.get(dependency.id)) == null) continue;
            ClassLoader loader2 = dependencyDescriptor.getClassLoader();
            if (loader2 == null) {
                ClassLoaderConfigurator.getLogger().error(PluginLoadingError.formatErrorMessage(mainDependent, "requires missing class loader for '" + dependencyDescriptor.getName() + "'"));
                continue;
            }
            if (loader2 == this.coreLoader) continue;
            this.loaders.add(loader2);
        }
        if (mainDependent.isUseIdeaClassLoader()) {
            ClassLoader classLoader = ClassLoaderConfigurator.configureUsingIdeaClassloader(classPath, mainDependent);
        } else {
            ClassLoader[] parentLoaders;
            if (this.loaders.isEmpty()) {
                ClassLoader[] classLoaderArray;
                if (this.usePluginClassLoader) {
                    classLoaderArray = EMPTY_CLASS_LOADER_ARRAY;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = this.coreLoader;
                }
                parentLoaders = classLoaderArray;
            } else {
                parentLoaders = this.loaders.toArray(EMPTY_CLASS_LOADER_ARRAY);
            }
            PluginClassLoader pluginClassLoader = new PluginClassLoader(this.urlClassLoaderBuilder, parentLoaders, (PluginDescriptor)mainDependent, mainDependent.getPluginPath(), this.usePluginClassLoader ? this.coreLoader : null);
        }
        if (SEPARATE_CLASSLOADER_FOR_SUB && this.usePluginClassLoader) {
            mainDependent.setClassLoader((ClassLoader)var5_9);
            this.configureSubPlugins((ClassLoader)var5_9, pluginDependencies, this.urlClassLoaderBuilder);
        } else {
            ClassLoaderConfigurator.setPluginClassLoaderForMainAndSubPlugins(mainDependent, (ClassLoader)var5_9);
        }
    }

    private void configureSubPlugins(@NotNull ClassLoader mainDependentClassLoader, @NotNull List<PluginDependency> pluginDependencies, @NotNull UrlClassLoader.Builder urlClassLoaderBuilder) {
        if (mainDependentClassLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(5);
        }
        if (pluginDependencies == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(6);
        }
        if (urlClassLoaderBuilder == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(7);
        }
        for (PluginDependency dependencyInfo : pluginDependencies) {
            IdeaPluginDescriptorImpl dependent = dependencyInfo.isDisabledOrBroken ? null : dependencyInfo.subDescriptor;
            if (dependent == null) continue;
            assert (!dependent.isUseIdeaClassLoader());
            this.loaders.clear();
            this.loaders.add(mainDependentClassLoader);
            IdeaPluginDescriptorImpl dependency = this.idMap.get(dependencyInfo.id);
            if (dependency != null) {
                this.addLoaderOrLogError(dependent, dependency, this.loaders);
            }
            dependent.setClassLoader((ClassLoader)((Object)new PluginClassLoader(urlClassLoaderBuilder, this.loaders.toArray(EMPTY_CLASS_LOADER_ARRAY), (PluginDescriptor)dependent, dependent.getPluginPath(), this.coreLoader)));
        }
    }

    @NotNull
    private static ClassLoader configureUsingIdeaClassloader(@NotNull List<Path> classPath, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        ClassLoader classLoader;
        if (classPath == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(9);
        }
        ClassLoaderConfigurator.getLogger().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader2 = ClassLoaderConfigurator.class.getClassLoader();
        try {
            Class<?> loaderClass = loader2.getClass();
            if (loaderClass.getName().endsWith(".BootstrapClassLoaderUtil$TransformingLoader")) {
                loaderClass = loaderClass.getSuperclass();
            }
            MethodHandle addURL = MethodHandles.lookup().findVirtual(loaderClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
            for (Path pathElement : classPath) {
                addURL.invoke(loader2, ClassLoaderConfigurator.localFileToUrl(pathElement, descriptor2));
            }
            classLoader = loader2;
        }
        catch (Throwable t) {
            throw new IllegalStateException("An unexpected core classloader: " + loader2.getClass(), t);
        }
        if (classLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(10);
        }
        return classLoader;
    }

    private void addLoaderOrLogError(@NotNull IdeaPluginDescriptorImpl dependent, @NotNull IdeaPluginDescriptorImpl dependency, @NotNull Collection<ClassLoader> loaders) {
        ClassLoader loader2;
        if (dependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(11);
        }
        if (dependency == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(12);
        }
        if (loaders == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(13);
        }
        if ((loader2 = dependency.getClassLoader()) == null) {
            ClassLoaderConfigurator.getLogger().error(PluginLoadingError.formatErrorMessage(dependent, "requires missing class loader for '" + dependency.getName() + "'"));
        } else if (loader2 != this.coreLoader) {
            loaders.add(loader2);
        }
    }

    static void setPluginClassLoaderForMainAndSubPlugins(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @Nullable ClassLoader classLoader) {
        if (rootDescriptor == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(14);
        }
        rootDescriptor.setClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.getPluginDependencies()) {
            if (dependency.subDescriptor == null) continue;
            ClassLoaderConfigurator.setPluginClassLoaderForMainAndSubPlugins(dependency.subDescriptor, classLoader);
        }
    }

    @NotNull
    private static URL localFileToUrl(@NotNull Path file2, @NotNull IdeaPluginDescriptor descriptor2) {
        URL uRL;
        if (file2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(15);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(16);
        }
        try {
            uRL = file2.normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException("Corrupted path element: `" + file2 + '`', (Throwable)e, descriptor2.getPluginId());
        }
        if (uRL == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(17);
        }
        return uRL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 3: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/ClassLoaderConfigurator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDependent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDependentClassLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDependencies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlClassLoaderBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/ClassLoaderConfigurator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configureUsingIdeaClassloader";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "localFileToUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureSubPlugins";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureUsingIdeaClassloader";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLoaderOrLogError";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setPluginClassLoaderForMainAndSubPlugins";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

