/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPopup
extends LightweightHint
implements Disposable {
    private static final String JBLIST_KEY = "OriginalList";
    private static final String DISPOSED_OBJECTS = "DISPOSED_OBJECTS";
    private final NavBarPanel myPanel;
    private final int myIndex;

    public NavBarPopup(NavBarPanel panel2, final int sourceItemIndex, Object[] siblings, final int selectedIndex) {
        super(NavBarPopup.createPopupContent(panel2, sourceItemIndex, siblings));
        this.myPanel = panel2;
        this.myIndex = selectedIndex;
        this.setFocusRequestor(this.getComponent());
        this.setForceShowAsPopup(true);
        panel2.installPopupHandler((JComponent)this.getList(), selectedIndex);
        this.getList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                NavBarPopup.this.myPanel.getModel().setSelectedIndex(selectedIndex);
                if (e.isPopupTrigger()) {
                    return;
                }
                Object value2 = NavBarPopup.this.getList().getSelectedValue();
                if (value2 != null) {
                    NavBarPopup.this.myPanel.navigateInsideBar(sourceItemIndex, value2);
                }
            }
        });
    }

    @Override
    protected void onPopupCancel() {
        Object o;
        JComponent component2 = this.getComponent();
        if (component2 != null && (o = component2.getClientProperty(JBLIST_KEY)) instanceof JComponent) {
            HintUpdateSupply.hideHint((JComponent)((JComponent)o));
        }
        for (Disposable disposable2 : (List)this.getList().getClientProperty((Object)DISPOSED_OBJECTS)) {
            Disposer.dispose((Disposable)disposable2);
        }
        Disposer.dispose((Disposable)this);
    }

    public void show(NavBarItem item) {
        this.show(item, true);
    }

    private void show(NavBarItem item, boolean checkRepaint) {
        UIEventLogger.NavBarShowPopup.log(this.myPanel.getProject());
        RelativePoint point = new RelativePoint((Component)((Object)item), new Point(0, item.getHeight()));
        Point p = point.getPoint((Component)this.myPanel);
        if (p.x == 0 && p.y == 0 && checkRepaint) {
            SwingUtilities.invokeLater(() -> {
                this.myPanel.getUpdateQueue().rebuildUi();
                SwingUtilities.invokeLater(() -> this.show(item, false));
            });
        } else {
            int offset = NavBarUIManager.getUI().getPopupOffset(item);
            this.show(this.myPanel, p.x - offset, p.y, this.myPanel, new HintHint(this.myPanel, p));
            JBList<?> list2 = this.getList();
            AccessibleContextUtil.setName(list2, (String)item.getText());
            if (0 <= this.myIndex && this.myIndex < list2.getItemsCount()) {
                ScrollingUtil.selectItem(list2, (int)this.myIndex);
            }
        }
        if (this.myPanel.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(this.getList());
            window.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    Window w = e.getOppositeWindow();
                    if (w != null && DialogWrapper.findInstance((Component)w.getComponent(0)) != null) {
                        NavBarPopup.this.myPanel.hideHint();
                    }
                }
            });
        }
    }

    public void dispose() {
    }

    private static JComponent createPopupContent(NavBarPanel panel2, int sourceItemIndex, Object[] siblings) {
        class MyList<E>
        extends JBList<E>
        implements DataProvider,
        Queryable {
            final /* synthetic */ NavBarPanel val$panel;

            MyList(NavBarPanel navBarPanel) {
                this.val$panel = navBarPanel;
            }

            public void putInfo(@NotNull Map<String, String> info) {
                if (info == null) {
                    MyList.$$$reportNull$$$0(0);
                }
                this.val$panel.putInfo(info);
            }

            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    MyList.$$$reportNull$$$0(1);
                }
                return this.val$panel.getDataImpl(dataId, (JComponent)((Object)this), () -> JBIterable.from((Iterable)this.getSelectedValuesList()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPopup$1MyList";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "putInfo";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getData";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyList list2 = new MyList(panel2);
        DataManager.registerDataProvider(list2, dataId -> panel2.getDataImpl(dataId, (JComponent)((Object)list2), () -> JBIterable.from((Iterable)list2.getSelectedValuesList())));
        list2.setModel((ListModel)new CollectionListModel(siblings));
        HintUpdateSupply.installSimpleHintUpdateSupply(list2);
        ArrayList items = new ArrayList();
        list2.putClientProperty(DISPOSED_OBJECTS, items);
        list2.installCellRenderer(obj -> {
            for (NavBarItem item : items) {
                if (obj != item.getObject()) continue;
                item.update();
                return item;
            }
            NavBarItem item = new NavBarItem(panel2, obj, null, true);
            items.add(item);
            return item;
        });
        list2.setBorder(JBUI.Borders.empty((int)5));
        ActionMap map2 = list2.getActionMap();
        map2.put("selectPreviousColumn", NavBarPopup.createMoveAction(panel2, -1));
        map2.put("selectNextColumn", NavBarPopup.createMoveAction(panel2, 1));
        NavBarPopup.installEnterAction(list2, panel2, sourceItemIndex, 10);
        NavBarPopup.installEscapeAction(list2, panel2, 27);
        JComponent component2 = ListWithFilter.wrap(list2, (JScrollPane)((Object)new NavBarListWrapper((JList)((Object)list2))), o -> panel2.getPresentation().getPresentableText(o, false));
        component2.putClientProperty(JBLIST_KEY, (Object)list2);
        OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick(component2);
        return component2;
    }

    private static void installEnterAction(final JBList list2, final NavBarPanel panel2, final int sourceItemIndex, int keyCode) {
        AbstractAction action2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.navigateInsideBar(sourceItemIndex, list2.getSelectedValue());
            }
        };
        list2.registerKeyboardAction((ActionListener)action2, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    private static void installEscapeAction(JBList list2, final NavBarPanel panel2, int keyCode) {
        AbstractAction action2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.cancelPopup();
            }
        };
        list2.registerKeyboardAction((ActionListener)action2, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    @NotNull
    public JBList<?> getList() {
        JBList jBList = (JBList)this.getComponent().getClientProperty(JBLIST_KEY);
        if (jBList == null) {
            NavBarPopup.$$$reportNull$$$0(0);
        }
        return jBList;
    }

    private static Action createMoveAction(final @NotNull NavBarPanel panel2, final int direction) {
        if (panel2 == null) {
            NavBarPopup.$$$reportNull$$$0(1);
        }
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.cancelPopup();
                panel2.shiftFocus(direction);
                panel2.restorePopup();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPopup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMoveAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

