/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;

public class CustomFileTypeQuoteHandler
implements QuoteHandler {
    @Override
    public boolean isClosingQuote(HighlighterIterator iterator2, int offset) {
        IElementType tokenType = iterator2.getTokenType();
        if (CustomFileTypeQuoteHandler.isQuotedToken(tokenType)) {
            int start2 = iterator2.getStart();
            int end = iterator2.getEnd();
            return end - start2 >= 1 && offset == end - 1;
        }
        return false;
    }

    static boolean isQuotedToken(IElementType tokenType) {
        return tokenType == CustomHighlighterTokenType.STRING || tokenType == CustomHighlighterTokenType.SINGLE_QUOTED_STRING || tokenType == CustomHighlighterTokenType.CHARACTER;
    }

    static char getLimitingQuote(IElementType quotedToken) {
        if (quotedToken == CustomHighlighterTokenType.STRING) {
            return '\"';
        }
        if (quotedToken == CustomHighlighterTokenType.SINGLE_QUOTED_STRING || quotedToken == CustomHighlighterTokenType.CHARACTER) {
            return '\'';
        }
        return '\u0000';
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator2, int offset) {
        if (CustomFileTypeQuoteHandler.isQuotedToken(iterator2.getTokenType())) {
            int start2 = iterator2.getStart();
            return offset == start2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator2, int offset) {
        try {
            Document doc = editor.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator2.atEnd() && iterator2.getStart() < lineEnd) {
                if (CustomFileTypeQuoteHandler.isQuotedToken(iterator2.getTokenType()) && (iterator2.getStart() >= iterator2.getEnd() - 1 || chars.charAt(iterator2.getEnd() - 1) != '\"' && chars.charAt(iterator2.getEnd() - 1) != '\'')) {
                    boolean bl = true;
                    return bl;
                }
                iterator2.advance();
            }
        }
        finally {
            while (!iterator2.atEnd() && iterator2.getStart() != offset) {
                iterator2.retreat();
            }
        }
        return false;
    }

    @Override
    public boolean isInsideLiteral(HighlighterIterator iterator2) {
        return CustomFileTypeQuoteHandler.isQuotedToken(iterator2.getTokenType());
    }
}

