/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardInteractionType;
import com.intellij.ide.customize.CustomizeIDEWizardInteractions;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomizeUIThemeStepPanel
extends AbstractCustomizeWizardStep {
    protected static final ThemeInfo DARCULA = new ThemeInfo("Darcula", "Darcula", DarculaLaf.class.getName());
    protected static final ThemeInfo INTELLIJ = new ThemeInfo("Light", "IntelliJ", IntelliJLaf.class.getName());
    private final boolean myColumnMode;
    private final JLabel myPreviewLabel;
    private final Set<ThemeInfo> myThemes = new LinkedHashSet<ThemeInfo>();

    public CustomizeUIThemeStepPanel() {
        this.setLayout(CustomizeUIThemeStepPanel.createSmallBorderLayout());
        this.initThemes(this.myThemes);
        this.myColumnMode = this.myThemes.size() > 2;
        JPanel buttonsPanel = new JPanel(new GridLayout(this.myColumnMode ? this.myThemes.size() : 1, this.myColumnMode ? 1 : this.myThemes.size(), 5, 5));
        ButtonGroup group2 = new ButtonGroup();
        ThemeInfo myDefaultTheme = this.getDefaultTheme();
        for (ThemeInfo theme2 : this.myThemes) {
            @NlsSafe String themName = theme2.name;
            JRadioButton radioButton = new JRadioButton(themName, myDefaultTheme == theme2);
            radioButton.setOpaque(false);
            JPanel panel2 = CustomizeUIThemeStepPanel.createBigButtonPanel(CustomizeUIThemeStepPanel.createSmallBorderLayout(), radioButton, () -> {
                CustomizeIDEWizardInteractions.INSTANCE.record(CustomizeIDEWizardInteractionType.UIThemeChanged);
                this.applyLaf(theme2, this);
                theme2.apply();
            });
            panel2.setBorder(CustomizeUIThemeStepPanel.createSmallEmptyBorder());
            panel2.add((Component)radioButton, this.myColumnMode ? "West" : "North");
            Icon icon2 = theme2.getIcon();
            int maxThumbnailSize = 400 / this.myThemes.size();
            JLabel label2 = new JLabel(this.myColumnMode ? IconUtil.scale((Icon)IconUtil.cropIcon((Icon)icon2, (int)(maxThumbnailSize * 2), (int)(maxThumbnailSize * 2)), (Component)this, (float)0.5f) : icon2);
            label2.setVerticalAlignment(1);
            label2.setHorizontalAlignment(4);
            panel2.add((Component)label2, "Center");
            group2.add(radioButton);
            buttonsPanel.add(panel2);
        }
        this.add((Component)buttonsPanel, "Center");
        this.myPreviewLabel = new JLabel();
        this.myPreviewLabel.setHorizontalAlignment(this.myColumnMode ? 2 : 0);
        this.myPreviewLabel.setVerticalAlignment(0);
        if (this.myColumnMode) {
            this.add((Component)buttonsPanel, "West");
            JPanel wrapperPanel = new JPanel(new FlowLayout(0, 0, 0));
            wrapperPanel.add(this.myPreviewLabel);
            this.add((Component)wrapperPanel, "Center");
        }
        this.applyLaf(myDefaultTheme, this);
        SwingUtilities.invokeLater(() -> this.applyLaf(myDefaultTheme, this));
    }

    protected void initThemes(Collection<? super ThemeInfo> result2) {
        if (SystemInfo.isMac) {
            result2.add(DARCULA);
            result2.add(CustomizeUIThemeStepPanel.getDefaultLafOnMac());
        } else if (SystemInfo.isWindows) {
            result2.add(DARCULA);
            result2.add(INTELLIJ);
        } else {
            result2.add(DARCULA);
            result2.add(INTELLIJ);
        }
    }

    @NotNull
    protected static ThemeInfo getDefaultLafOnMac() {
        ThemeInfo themeInfo = INTELLIJ;
        if (themeInfo == null) {
            CustomizeUIThemeStepPanel.$$$reportNull$$$0(0);
        }
        return themeInfo;
    }

    @NotNull
    private ThemeInfo getDefaultTheme() {
        ThemeInfo result2;
        String lafClassName;
        if (ApplicationManager.getApplication() != null) {
            if (StartupUiUtil.isUnderDarcula()) {
                ThemeInfo themeInfo = DARCULA;
                if (themeInfo == null) {
                    CustomizeUIThemeStepPanel.$$$reportNull$$$0(1);
                }
                return themeInfo;
            }
            ThemeInfo themeInfo = INTELLIJ;
            if (themeInfo == null) {
                CustomizeUIThemeStepPanel.$$$reportNull$$$0(2);
            }
            return themeInfo;
        }
        CloudConfigProvider provider2 = CloudConfigProvider.getProvider();
        if (provider2 != null && (lafClassName = provider2.getLafClassName()) != null && (result2 = (ThemeInfo)ContainerUtil.find(this.myThemes, theme2 -> lafClassName.equals(theme2.laf))) != null) {
            ThemeInfo themeInfo = result2;
            if (themeInfo == null) {
                CustomizeUIThemeStepPanel.$$$reportNull$$$0(3);
            }
            return themeInfo;
        }
        ThemeInfo themeInfo = this.myThemes.iterator().next();
        if (themeInfo == null) {
            CustomizeUIThemeStepPanel.$$$reportNull$$$0(4);
        }
        return themeInfo;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 30;
        return size;
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"step.title.ui.themes", (Object[])new Object[0]);
    }

    @Override
    public String getHTMLHeader() {
        return IdeBundle.message((String)"label.set.ui.theme", (Object[])new Object[0]);
    }

    @Override
    public String getHTMLFooter() {
        return IdeBundle.message((String)"label.you.can.change.the.ui.theme.later.in.0.1", (Object[])new Object[]{CommonBundle.settingsTitle(), OptionsBundle.message((String)"configurable.group.appearance.settings.display.name", (Object[])new Object[0]), CommonBundle.settingsTitle()});
    }

    private void applyLaf(ThemeInfo theme2, Component component2) {
        UIManager.LookAndFeelInfo info = new UIManager.LookAndFeelInfo(theme2.name, theme2.laf);
        try {
            boolean wasUnderDarcula = StartupUiUtil.isUnderDarcula();
            UIManager.setLookAndFeel(info.getClassName());
            AppUIUtil.updateForDarcula(StartupUiUtil.isUnderDarcula());
            String className = info.getClassName();
            WelcomeWizardUtil.setWizardLAF((String)className);
            Window window = SwingUtilities.getWindowAncestor(component2);
            if (window != null) {
                if (SystemInfo.isMac) {
                    window.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
                }
                SwingUtilities.updateComponentTreeUI(window);
            }
            if (ApplicationManager.getApplication() != null) {
                LafManager lafManager = LafManager.getInstance();
                lafManager.setCurrentLookAndFeel(info);
                if (lafManager instanceof LafManagerImpl) {
                    ((LafManagerImpl)lafManager).updateWizardLAF(wasUnderDarcula);
                } else {
                    lafManager.updateUI();
                }
            }
            if (this.myColumnMode) {
                this.myPreviewLabel.setIcon(theme2.getIcon());
                this.myPreviewLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/customize/CustomizeUIThemeStepPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLafOnMac";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTheme";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ThemeInfo {
        @NonNls
        public final String name;
        @NonNls
        public final String previewFileName;
        @NonNls
        public final String laf;
        private Icon icon;

        public ThemeInfo(@NonNls String name, @NonNls String previewFileName, @NonNls String laf) {
            this.name = name;
            this.previewFileName = SystemInfo.isMac && "IntelliJ".equals(previewFileName) ? "Aqua" : previewFileName;
            this.laf = laf;
        }

        private Icon getIcon() {
            if (this.icon == null) {
                String selector = SystemInfo.isMac ? "OSX" : (SystemInfo.isWindows ? "Windows" : "Linux");
                this.icon = IconLoader.getIcon((String)("/lafs/" + selector + this.previewFileName + ".png"));
            }
            return this.icon;
        }

        public void apply() {
        }
    }
}

