/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UndoRedoAction
extends DumbAwareAction
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(UndoRedoAction.class);
    public static final Key<Boolean> IGNORE_SWING_UNDO_MANAGER = new Key("IGNORE_SWING_UNDO_MANAGER");
    private boolean myActionInProgress;

    public UndoRedoAction() {
        this.setEnabledInModalContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            UndoRedoAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = this.getUndoManager(editor, dataContext);
        this.myActionInProgress = true;
        try {
            this.perform(editor, undoManager);
        }
        finally {
            this.myActionInProgress = false;
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            UndoRedoAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = this.getUndoManager(editor, dataContext);
        if (undoManager == null) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setEnabled(this.isAvailable(editor, undoManager));
        Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> pair = this.getActionNameAndDescription(editor, undoManager);
        presentation2.setText((String)pair.first);
        presentation2.setDescription((String)pair.second);
    }

    private UndoManager getUndoManager(FileEditor editor, DataContext dataContext) {
        Component component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (component2 instanceof JTextComponent && !UIUtil.isClientPropertyTrue((Object)component2, IGNORE_SWING_UNDO_MANAGER)) {
            return SwingUndoManagerWrapper.fromContext(dataContext);
        }
        JRootPane rootPane = null;
        JBPopup popup2 = null;
        if (editor == null) {
            rootPane = UIUtil.getRootPane((Component)component2);
            popup2 = rootPane != null ? (JBPopup)rootPane.getClientProperty("JBPopup") : null;
            boolean modalPopup = popup2 != null && popup2.isModalContext();
            boolean modalContext = Boolean.TRUE.equals(PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext));
            if (modalPopup || modalContext) {
                return SwingUndoManagerWrapper.fromContext(dataContext);
            }
        }
        if (this.myActionInProgress) {
            LOG.error("Recursive undo invocation attempt, component: " + component2 + ", fileEditor: " + editor + ", rootPane: " + rootPane + ", popup: " + popup2);
            return null;
        }
        Project project = UndoRedoAction.getProject(editor, dataContext);
        return project != null && !project.isDefault() ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
    }

    private static Project getProject(FileEditor editor, DataContext dataContext) {
        Project project = editor instanceof TextEditor ? ((TextEditor)editor).getEditor().getProject() : (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project;
    }

    protected abstract void perform(FileEditor var1, UndoManager var2);

    protected abstract boolean isAvailable(FileEditor var1, UndoManager var2);

    protected abstract Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getActionNameAndDescription(FileEditor var1, UndoManager var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/UndoRedoAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SwingUndoManagerWrapper
    extends UndoManager {
        private final javax.swing.undo.UndoManager mySwingUndoManager;

        @Nullable
        static UndoManager fromContext(DataContext dataContext) {
            javax.swing.undo.UndoManager swingUndoManager = UIUtil.getUndoManager((Component)((Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)));
            return swingUndoManager != null ? new SwingUndoManagerWrapper(swingUndoManager) : null;
        }

        SwingUndoManagerWrapper(javax.swing.undo.UndoManager swingUndoManager) {
            this.mySwingUndoManager = swingUndoManager;
        }

        public void undoableActionPerformed(@NotNull UndoableAction action2) {
            if (action2 == null) {
                SwingUndoManagerWrapper.$$$reportNull$$$0(0);
            }
        }

        public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
            if (ref == null) {
                SwingUndoManagerWrapper.$$$reportNull$$$0(1);
            }
        }

        public boolean isUndoInProgress() {
            return false;
        }

        public boolean isRedoInProgress() {
            return false;
        }

        public void undo(@Nullable FileEditor editor) {
            this.mySwingUndoManager.undo();
        }

        public void redo(@Nullable FileEditor editor) {
            this.mySwingUndoManager.redo();
        }

        public boolean isUndoAvailable(@Nullable FileEditor editor) {
            return this.mySwingUndoManager.canUndo();
        }

        public boolean isRedoAvailable(@Nullable FileEditor editor) {
            return this.mySwingUndoManager.canRedo();
        }

        @NotNull
        public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor) {
            return SwingUndoManagerWrapper.getUndoOrRedoActionNameAndDescription(true);
        }

        @NotNull
        public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor) {
            return SwingUndoManagerWrapper.getUndoOrRedoActionNameAndDescription(false);
        }

        @NotNull
        private static Pair<String, String> getUndoOrRedoActionNameAndDescription(boolean undo) {
            if (undo) {
                Pair pair = Pair.create((Object)ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{""}).trim(), (Object)ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0])}).trim());
                if (pair == null) {
                    SwingUndoManagerWrapper.$$$reportNull$$$0(2);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{""}).trim(), (Object)ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0])}).trim());
            if (pair == null) {
                SwingUndoManagerWrapper.$$$reportNull$$$0(3);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/UndoRedoAction$SwingUndoManagerWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/UndoRedoAction$SwingUndoManagerWrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUndoOrRedoActionNameAndDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "undoableActionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "nonundoableActionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

