/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchAgainAction
extends EditorAction
implements DumbAware {
    public SearchAgainAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(true);
    }

    public static class Handler
    extends EditorActionHandler {
        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Project project;
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            FindManager findManager = FindManager.getInstance((Project)project);
            if (!findManager.selectNextOccurrenceWasPerformed() && findManager.findNextUsageInEditor(editor)) {
                return;
            }
            FindUtil.searchAgain(project, editor, dataContext);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            Project project;
            if (editor == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
                return false;
            }
            return !editor.isOneLineMode() && (Boolean)IncrementalFindAction.SEARCH_DISABLED.get((UserDataHolder)editor, (Object)false) == false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/SearchAgainAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

