/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.tree.TreeNode;

class FrameworkDirectoryNode
extends DetectedFrameworkTreeNodeBase {
    private static final Logger LOG = Logger.getInstance(FrameworkDirectoryNode.class);
    private final VirtualFile myDirectory;

    FrameworkDirectoryNode(VirtualFile directory) {
        super(directory);
        this.myDirectory = directory;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer2) {
        renderer2.setIcon(PlatformIcons.FOLDER_ICON);
        renderer2.append(this.getRelativePath());
    }

    @NlsSafe
    private String getRelativePath() {
        String path;
        TreeNode parent = this.getParent();
        if (parent instanceof FrameworkDirectoryNode) {
            VirtualFile parentDir = ((FrameworkDirectoryNode)((Object)parent)).myDirectory;
            path = VfsUtilCore.getRelativePath((VirtualFile)this.myDirectory, (VirtualFile)parentDir, (char)File.separatorChar);
            LOG.assertTrue(path != null, (Object)(this.myDirectory + " is not under " + parentDir));
        } else {
            path = this.myDirectory.getPresentableUrl();
        }
        return path;
    }

    @Override
    public String getCheckedDescription() {
        return null;
    }

    @Override
    public String getUncheckedDescription() {
        return ProjectBundle.message((String)"label.directory.will.be.excluded.from.framework.detection", (Object[])new Object[]{this.getRelativePath()});
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration) {
        configuration.addExcludedFile(this.myDirectory, null);
    }
}

