/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.collectors.fus.os.OsVersionUsageCollector;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTracker;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/SystemStateMonitor;", "Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageStateEventTracker;", "()V", "DEBUG", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "HEADLESS", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "INITIAL_DELAY", "", "OS_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "PERIOD_DELAY", "REPORT", "SESSION_GROUP", "TEST", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "anonymizeMachineId", "", "machineId", "getOSName", "initialize", "", "newDataWithOsVersion", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "reportNow", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "reportSessionInfo", "intellij.platform.ide.impl"})
public final class SystemStateMonitor
implements FeatureUsageStateEventTracker {
    private final EventLogGroup OS_GROUP = new EventLogGroup("system.os", 4);
    private final int INITIAL_DELAY;
    private final int PERIOD_DELAY;
    private final EventLogGroup SESSION_GROUP = new EventLogGroup("event.log.session", 1);
    private final EventId1<Boolean> DEBUG = this.SESSION_GROUP.registerEvent("debug.mode", (EventField)EventFields.Boolean((String)"debug_agent"));
    private final EventId2<Boolean, Boolean> REPORT = this.SESSION_GROUP.registerEvent("reporting", (EventField)EventFields.Boolean((String)"suppress_report"), (EventField)EventFields.Boolean((String)"only_local"));
    private final EventId3<Boolean, Boolean, Boolean> TEST = this.SESSION_GROUP.registerEvent("test.mode", (EventField)EventFields.Boolean((String)"fus_test"), (EventField)EventFields.Boolean((String)"internal"), (EventField)EventFields.Boolean((String)"teamcity"));
    private final EventId2<Boolean, Boolean> HEADLESS = this.SESSION_GROUP.registerEvent("headless", (EventField)EventFields.Boolean((String)"headless"), (EventField)EventFields.Boolean((String)"command_line"));

    public void initialize() {
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ SystemStateMonitor this$0;

            public final void run() {
                this.this$0.reportNow();
            }
            {
                this.this$0 = systemStateMonitor;
            }
        }, this.INITIAL_DELAY, this.PERIOD_DELAY, TimeUnit.MINUTES);
    }

    @NotNull
    public CompletableFuture<Void> reportNow() {
        this.reportSessionInfo();
        List osEvents = new ArrayList();
        FeatureUsageData dataOS = this.newDataWithOsVersion();
        osEvents.add(MetricEventFactoryKt.newMetric((String)this.getOSName(), (FeatureUsageData)dataOS));
        osEvents.add(MetricEventFactoryKt.newMetric((String)"os.name", (FeatureUsageData)dataOS.copy().addData("name", this.getOSName())));
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"OffsetDateTime.now()");
        ZoneOffset currentZoneOffset = offsetDateTime.getOffset();
        FeatureUsageData featureUsageData = new FeatureUsageData();
        String string = currentZoneOffset.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentZoneOffset.toString()");
        FeatureUsageData currentZoneOffsetFeatureUsageData = featureUsageData.addData("value", string);
        osEvents.add(MetricEventFactoryKt.newMetric((String)"os.timezone", (FeatureUsageData)currentZoneOffsetFeatureUsageData));
        String machineId = MachineIdManager.INSTANCE.getMachineId();
        osEvents.add(MetricEventFactoryKt.newMetric((String)"machine.id", (FeatureUsageData)new FeatureUsageData().addData("value", this.anonymizeMachineId(machineId))));
        CompletableFuture completableFuture = FUStateUsagesLogger.logStateEventsAsync((EventLogGroup)this.OS_GROUP, (Collection)osEvents);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"FUStateUsagesLogger.logS\u2026Async(OS_GROUP, osEvents)");
        return completableFuture;
    }

    private final void reportSessionInfo() {
        List events = new ArrayList();
        Application app = ApplicationManager.getApplication();
        events.add(this.DEBUG.metric((Object)DebugAttachDetector.isDebugEnabled()));
        events.add(this.REPORT.metric((Object)StatisticsUploadAssistant.isSuppressStatisticsReport(), (Object)StatisticsUploadAssistant.isLocalStatisticsWithoutReport()));
        Boolean bl = TestModeValidationRule.isTestModeEnabled();
        Application application = app;
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        events.add(this.TEST.metric((Object)bl, (Object)application.isInternal(), (Object)StatisticsUploadAssistant.isTeamcityDetected()));
        events.add(this.HEADLESS.metric((Object)app.isHeadlessEnvironment(), (Object)app.isCommandLine()));
        FUStateUsagesLogger.logStateEventsAsync((EventLogGroup)this.SESSION_GROUP, (Collection)events);
    }

    private final String anonymizeMachineId(String machineId) {
        String salt;
        if (machineId == null) {
            return "unknown";
        }
        String string = salt = System.getProperty("user.name") + "JetBrainsFUS";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EventLogConfiguration.INSTANCE.hashSha256(byArray, machineId);
    }

    private final FeatureUsageData newDataWithOsVersion() {
        FeatureUsageData osData = new FeatureUsageData();
        if (SystemInfo.isLinux) {
            OsVersionUsageCollector.LinuxRelease linuxRelease = OsVersionUsageCollector.getLinuxRelease();
            Intrinsics.checkNotNullExpressionValue((Object)linuxRelease, (String)"OsVersionUsageCollector.getLinuxRelease()");
            OsVersionUsageCollector.LinuxRelease linuxRelease2 = linuxRelease;
            String string = linuxRelease2.getRelease();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"linuxRelease.release");
            osData.addData("release", string);
            osData.addVersionByString(linuxRelease2.getVersion());
        } else {
            osData.addVersion(OsVersionUsageCollector.parse((String)SystemInfo.OS_VERSION));
        }
        return osData;
    }

    private final String getOSName() {
        return SystemInfo.isLinux ? "Linux" : (SystemInfo.isMac ? "Mac" : (SystemInfo.isWindows ? "Windows" : (SystemInfo.isFreeBSD ? "FreeBSD" : (SystemInfo.isSolaris ? "Solaris" : "Other"))));
    }

    public SystemStateMonitor() {
        this.INITIAL_DELAY = 5;
        this.PERIOD_DELAY = 1440;
    }
}

