/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Condition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class ProcessBackedConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler
implements Condition<LanguageConsoleView> {
    private volatile ProcessHandler myProcessHandler;

    public ProcessBackedConsoleExecuteActionHandler(ProcessHandler processHandler2, boolean preserveMarkup) {
        super(preserveMarkup);
        this.myProcessHandler = processHandler2;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            ProcessBackedConsoleExecuteActionHandler.$$$reportNull$$$0(0);
        }
        this.myProcessHandler = processHandler2;
    }

    @Override
    protected void execute(@NotNull String text2, @NotNull LanguageConsoleView console) {
        if (text2 == null) {
            ProcessBackedConsoleExecuteActionHandler.$$$reportNull$$$0(1);
        }
        if (console == null) {
            ProcessBackedConsoleExecuteActionHandler.$$$reportNull$$$0(2);
        }
        this.processLine(text2);
    }

    public void processLine(@NotNull String line) {
        if (line == null) {
            ProcessBackedConsoleExecuteActionHandler.$$$reportNull$$$0(3);
        }
        this.sendText(line + "\n");
    }

    public void sendText(String line) {
        Charset charset = this.myProcessHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)this.myProcessHandler).getCharset() : null;
        OutputStream outputStream = this.myProcessHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        try {
            byte[] bytes = charset != null ? line.getBytes(charset) : line.getBytes(StandardCharsets.UTF_8);
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isProcessTerminated() {
        ProcessHandler handler2 = this.myProcessHandler;
        return handler2 == null || handler2.isProcessTerminated();
    }

    public boolean value(LanguageConsoleView console) {
        return !this.isProcessTerminated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProcessHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

