/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.ShowBlankDiffWindowActionKt;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diff/actions/ShowBlankDiffWindowAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.diff.impl"})
public final class ShowBlankDiffWindowAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        String defaultText = null;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && editor.getSelectionModel().hasSelection()) {
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
            defaultText = selectionModel.getSelectedText();
        }
        String string = StringUtil.notNullize((String)defaultText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.notNullize(defaultText)");
        DocumentContent content1 = ShowBlankDiffWindowActionKt.access$createEditableContent(project, string);
        DocumentContent content2 = ShowBlankDiffWindowActionKt.access$createEditableContent(project, "");
        MutableDiffRequestChain chain = new MutableDiffRequestChain((DiffContent)content1, (DiffContent)content2);
        chain.putUserData(DiffUserDataKeysEx.FORCE_DIFF_TOOL, SimpleDiffTool.INSTANCE);
        chain.putUserData(ShowBlankDiffWindowActionKt.access$getBLANK_KEY$p(), true);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    public ShowBlankDiffWindowAction() {
        this.setEnabledInModalContext(true);
    }
}

