/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(0);
        }
        if ((selectedFile = CompareFileWithEditorAction.getSelectedFile(e)) == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        VirtualFile[] array2;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(1);
        }
        if ((array2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || array2.length != 1 || array2[0].isDirectory()) {
            return null;
        }
        return array2[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        EditorWindow window = FileEditorManagerEx.getInstanceEx(project).getCurrentWindow();
        if (window == null) {
            return null;
        }
        EditorWithProviderComposite editor = window.getSelectedEditor(true);
        return editor == null ? null : editor.getFile();
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(4);
        }
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @NotNull
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        assert (selectedFile != null && currentFile != null);
        MutableDiffRequestChain chain = CompareFileWithEditorAction.createMutableChainFromFiles(project, selectedFile, currentFile);
        DiffContent editorContent = chain.getContent2();
        if (editorContent instanceof DocumentContent && (editor = (Editor)EditorFactory.getInstance().editors(((DocumentContent)editorContent).getDocument()).findFirst().orElse(null)) != null) {
            int currentLine = editor.getCaretModel().getLogicalPosition().line;
            chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        }
        MutableDiffRequestChain mutableDiffRequestChain = chain;
        if (mutableDiffRequestChain == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(6);
        }
        return mutableDiffRequestChain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareFileWithEditorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareFileWithEditorAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffRequestChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEditingFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canCompare";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

