/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class SynchronizedBidiMultiMap<K, V> {
    private final Map<K, V[]> myKey2Values = new THashMap();
    private final Map<V, K> myValue2Keys = new THashMap();

    public synchronized Collection<K> keys() {
        return new ArrayList<K>(this.myKey2Values.keySet());
    }

    public synchronized boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public synchronized boolean containsValue(V value2) {
        return this.myValue2Keys.containsKey(value2);
    }

    public synchronized K getKeyFor(V value2) {
        return this.myValue2Keys.get(value2);
    }

    public synchronized V[] get(K key) {
        return this.myKey2Values.get(key);
    }

    public synchronized V[] getOrDefault(K key, V[] defaultValue) {
        V[] values = this.get(key);
        return values == null ? defaultValue : values;
    }

    public synchronized void put(K key, V ... values) {
        this.myKey2Values.merge(key, (Object[][])values, (BiFunction<Object[][], Object[][], Object[][]>)((BiFunction<Object[], Object[], Object[]>)(arr1, arr2) -> {
            Object[] mergeResult = this.arrayFactory().create(((Object[])arr1).length + ((Object[])arr2).length);
            System.arraycopy(arr1, 0, mergeResult, 0, ((Object[])arr1).length);
            System.arraycopy(arr2, 0, mergeResult, ((Object[])arr1).length, ((Object[])arr2).length);
            return mergeResult;
        }));
        for (V value2 : values) {
            this.myValue2Keys.put(value2, key);
        }
    }

    public synchronized V[] remove(K key, V value2) {
        Object[] newValues = this.myKey2Values.computeIfPresent(key, (k, vs) -> {
            Object[] removed = ArrayUtil.remove((Object[])vs, (Object)value2, this.arrayFactory());
            if (removed.length == 0) {
                return null;
            }
            return removed;
        });
        this.myValue2Keys.remove(value2);
        return newValues;
    }

    public synchronized K removeValue(V value2) {
        K key = this.myValue2Keys.get(value2);
        if (key != null) {
            this.remove(key, value2);
        }
        return key;
    }

    public synchronized V[] remove(K key) {
        V[] removed = this.myKey2Values.remove(key);
        if (removed != null) {
            for (V v : removed) {
                this.myValue2Keys.remove(v);
            }
        }
        return removed;
    }

    public synchronized Collection<V> getValues() {
        return this.myValue2Keys.keySet();
    }

    public synchronized boolean isEmpty() {
        return this.myValue2Keys.isEmpty();
    }

    @TestOnly
    public Map<K, V[]> getMap() {
        return this.myKey2Values;
    }

    @NotNull
    protected abstract ArrayFactory<V> arrayFactory();
}

