/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseIndentEnterHandler
extends EnterHandlerDelegateAdapter {
    private final Language myLanguage;
    private final TokenSet myIndentTokens;
    private final IElementType myLineCommentType;
    private final String myLineCommentPrefix;
    private final TokenSet myWhitespaceTokens;
    private final boolean myWorksWithFormatter;

    public BaseIndentEnterHandler(Language language, TokenSet indentTokens, IElementType lineCommentType, String lineCommentPrefix, TokenSet whitespaceTokens) {
        this(language, indentTokens, lineCommentType, lineCommentPrefix, whitespaceTokens, false);
    }

    public BaseIndentEnterHandler(Language language, TokenSet indentTokens, IElementType lineCommentType, String lineCommentPrefix, TokenSet whitespaceTokens, boolean worksWithFormatter) {
        this.myLanguage = language;
        this.myIndentTokens = indentTokens;
        this.myLineCommentType = lineCommentType;
        this.myLineCommentPrefix = lineCommentPrefix;
        this.myWhitespaceTokens = whitespaceTokens;
        this.myWorksWithFormatter = worksWithFormatter;
    }

    protected EnterHandlerDelegate.Result shouldSkipWithResult(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Project project;
        if (file2 == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(2);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!file2.getViewProvider().getLanguages().contains(this.myLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (editor.isViewer()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        if (!document.isWritable()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        if (caret <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return null;
    }

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterHandlerDelegate.Result res2;
        if (file2 == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(4);
        }
        if (caretOffset == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(5);
        }
        if (caretAdvance == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(7);
        }
        if ((res2 = this.shouldSkipWithResult(file2, editor, dataContext)) != null) {
            return res2;
        }
        Document document = editor.getDocument();
        int caret = editor.getCaretModel().getOffset();
        int lineNumber = document.getLineNumber(caret);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int previousLineStartOffset = lineNumber > 0 ? document.getLineStartOffset(lineNumber - 1) : lineStartOffset;
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator2 = highlighter.createIterator(caret - 1);
        IElementType type = this.getNonWhitespaceElementType(iterator2, lineStartOffset, previousLineStartOffset);
        CharSequence editorCharSequence = document.getCharsSequence();
        CharSequence lineIndent = editorCharSequence.subSequence(lineStartOffset, EditorActionUtil.findFirstNonSpaceOffsetOnTheLine(document, lineNumber));
        if (type == this.myLineCommentType) {
            String restString = editorCharSequence.subSequence(caret, document.getLineEndOffset(lineNumber)).toString();
            if (!StringUtil.isEmptyOrSpaces((String)restString)) {
                String linePrefix = lineIndent + this.myLineCommentPrefix;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + linePrefix));
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineNumber + 1, linePrefix.length()));
                return EnterHandlerDelegate.Result.Stop;
            }
            if (iterator2.getStart() < lineStartOffset) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + lineIndent));
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        if (!this.myWorksWithFormatter && LanguageFormatting.INSTANCE.forLanguage(this.myLanguage) != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.myIndentTokens.contains(type)) {
            String newIndent = this.getNewIndent(file2, document, lineIndent);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + newIndent));
            return EnterHandlerDelegate.Result.Stop;
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + lineIndent));
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineNumber + 1, BaseIndentEnterHandler.calcLogicalLength(editor, lineIndent)));
        return EnterHandlerDelegate.Result.Stop;
    }

    protected String getNewIndent(@NotNull PsiFile file2, @NotNull Document document, @NotNull CharSequence oldIndent) {
        if (file2 == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(8);
        }
        if (document == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(9);
        }
        if (oldIndent == null) {
            BaseIndentEnterHandler.$$$reportNull$$$0(10);
        }
        CharSequence nonEmptyIndent = oldIndent;
        CharSequence editorCharSequence = document.getCharsSequence();
        int nLines = document.getLineCount();
        for (int line = 0; line < nLines && nonEmptyIndent.length() == 0; ++line) {
            int indentEnd;
            int lineStart = document.getLineStartOffset(line);
            if (lineStart >= (indentEnd = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine(document, line))) continue;
            nonEmptyIndent = editorCharSequence.subSequence(lineStart, indentEnd);
        }
        boolean usesSpacesForIndentation = nonEmptyIndent.length() > 0 && nonEmptyIndent.charAt(nonEmptyIndent.length() - 1) == ' ';
        boolean firstIndent = nonEmptyIndent.length() == 0;
        CodeStyleSettings currentSettings = CodeStyle.getSettings((PsiFile)file2);
        CommonCodeStyleSettings.IndentOptions indentOptions = currentSettings.getIndentOptions(file2.getFileType());
        if (firstIndent && indentOptions.USE_TAB_CHARACTER || !firstIndent && !usesSpacesForIndentation) {
            int nTabsToIndent = indentOptions.INDENT_SIZE / indentOptions.TAB_SIZE;
            if (indentOptions.INDENT_SIZE % indentOptions.TAB_SIZE != 0) {
                ++nTabsToIndent;
            }
            return oldIndent + StringUtil.repeatSymbol((char)'\t', (int)nTabsToIndent);
        }
        return oldIndent + StringUtil.repeatSymbol((char)' ', (int)indentOptions.INDENT_SIZE);
    }

    private static int calcLogicalLength(Editor editor, CharSequence lineIndent) {
        int result2 = 0;
        for (int i2 = 0; i2 < lineIndent.length(); ++i2) {
            if (lineIndent.charAt(i2) == '\t') {
                result2 += EditorUtil.getTabSize(editor);
                continue;
            }
            ++result2;
        }
        return result2;
    }

    @Nullable
    protected IElementType getNonWhitespaceElementType(HighlighterIterator iterator2, int currentLineStartOffset, int prevLineStartOffset) {
        while (!iterator2.atEnd() && iterator2.getEnd() >= currentLineStartOffset && iterator2.getStart() >= prevLineStartOffset) {
            IElementType tokenType = iterator2.getTokenType();
            if (!this.myWhitespaceTokens.contains(tokenType)) {
                return tokenType;
            }
            iterator2.retreat();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldIndent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkipWithResult";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewIndent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

