/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPreselectionBehaviourProvider;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.DefaultCompletionContributor;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.SyncCompletion;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class CompletionProgressIndicator
extends ProgressIndicatorBase
implements CompletionProcessEx,
Disposable {
    private static final Logger LOG = Logger.getInstance(CompletionProgressIndicator.class);
    private final Editor myEditor;
    @NotNull
    private final Caret myCaret;
    @Nullable
    private CompletionParameters myParameters;
    private final CodeCompletionHandlerBase myHandler;
    private final CompletionLookupArrangerImpl myArranger;
    private final CompletionType myCompletionType;
    private final int myInvocationCount;
    private OffsetsInFile myHostOffsets;
    private final LookupImpl myLookup;
    private final MergingUpdateQueue myQueue;
    private final Update myUpdate;
    private final Semaphore myFreezeSemaphore;
    private final Semaphore myFinishSemaphore;
    @NotNull
    private final OffsetMap myOffsetMap;
    private final Set<Pair<Integer, ElementPattern<String>>> myRestartingPrefixConditions;
    private final LookupListener myLookupListener;
    private static int ourInsertSingleItemTimeSpan = 300;
    private static int ourShowPopupGroupingTime = 300;
    private static int ourShowPopupAfterFirstItemGroupingTime = 100;
    private volatile int myCount;
    private volatile boolean myHasPsiElements;
    private boolean myLookupUpdated;
    private final PropertyChangeListener myLookupManagerListener;
    private final Queue<Runnable> myAdvertiserChanges;
    private final List<CompletionResult> myDelayedMiddleMatches;
    private final int myStartCaret;
    private final CompletionThreadingBase myThreading;
    private final Object myLock;
    private final EmptyCompletionNotifier myEmptyCompletionNotifier;

    CompletionProgressIndicator(Editor editor, @NotNull Caret caret, int invocationCount, CodeCompletionHandlerBase handler2, @NotNull OffsetMap offsetMap, @NotNull OffsetsInFile hostOffsets, boolean hasModifiers, @NotNull LookupImpl lookup2) {
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(0);
        }
        if (offsetMap == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(1);
        }
        if (hostOffsets == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(2);
        }
        if (lookup2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(3);
        }
        this.myUpdate = new Update("update"){

            public void run() {
                CompletionProgressIndicator.this.updateLookup();
                CompletionProgressIndicator.this.myQueue.setMergingTimeSpan(ourShowPopupGroupingTime);
            }
        };
        this.myFreezeSemaphore = new Semaphore(1);
        this.myFinishSemaphore = new Semaphore(1);
        this.myRestartingPrefixConditions = Collections.newSetFromMap(new ConcurrentHashMap());
        this.myLookupListener = new LookupListener(){

            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompletionProgressIndicator.this.finishCompletionProcess(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/completion/CompletionProgressIndicator$2", "lookupCanceled"));
            }
        };
        this.myAdvertiserChanges = new ConcurrentLinkedQueue<Runnable>();
        this.myDelayedMiddleMatches = new ArrayList<CompletionResult>();
        this.myLock = ObjectUtils.sentinel((String)"CompletionProgressIndicator");
        this.myEditor = editor;
        this.myCaret = caret;
        this.myHandler = handler2;
        this.myCompletionType = handler2.completionType;
        this.myInvocationCount = invocationCount;
        this.myOffsetMap = offsetMap;
        this.myHostOffsets = hostOffsets;
        this.myLookup = lookup2;
        this.myStartCaret = this.myEditor.getCaretModel().getOffset();
        this.myThreading = ApplicationManager.getApplication().isWriteAccessAllowed() || this.myHandler.isTestingCompletionQualityMode() ? new SyncCompletion() : new AsyncCompletion();
        this.myAdvertiserChanges.offer(() -> this.myLookup.getAdvertiser().clearAdvertisements());
        this.myArranger = new CompletionLookupArrangerImpl(this);
        this.myLookup.setArranger(this.myArranger);
        this.myLookup.addLookupListener(this.myLookupListener);
        this.myLookup.setCalculating(true);
        this.myEmptyCompletionNotifier = LightEdit.owns((Project)editor.getProject()) ? LightEditUtil.createEmptyCompletionNotifier() : new ProjectEmptyCompletionNotifier();
        this.myLookupManagerListener = evt -> {
            if (evt.getNewValue() != null) {
                LOG.error("An attempt to change the lookup during completion, phase = " + CompletionServiceImpl.getCompletionPhase());
            }
        };
        LookupManager.getInstance(this.getProject()).addPropertyChangeListener(this.myLookupManagerListener);
        this.myQueue = new MergingUpdateQueue("completion lookup progress", ourShowPopupAfterFirstItemGroupingTime, true, this.myEditor.getContentComponent());
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (hasModifiers && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackModifiers();
        }
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        boolean dispose2 = lookupItem == null;
        this.finishCompletionProcess(dispose2);
        if (dispose2) {
            return;
        }
        this.setMergeCommand();
        this.myHandler.lookupItemSelected(this, lookupItem, completionChar, this.myLookup.getItems());
    }

    @Override
    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(4);
        }
        return offsetMap;
    }

    @Override
    @NotNull
    public OffsetsInFile getHostOffsets() {
        OffsetsInFile offsetsInFile = this.myHostOffsets;
        if (offsetsInFile == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(5);
        }
        return offsetsInFile;
    }

    private void duringCompletion(CompletionInitializationContext initContext, CompletionParameters parameters2) {
        PsiUtilCore.ensureValid((PsiElement)parameters2.getPosition());
        if (this.isAutopopupCompletion() && CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters2)) {
            this.myLookup.setLookupFocusDegree(CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars() ? LookupFocusDegree.FOCUSED : LookupFocusDegree.SEMI_FOCUSED);
        }
        this.addDefaultAdvertisements(parameters2);
        ProgressManager.checkCanceled();
        Document document = initContext.getEditor().getDocument();
        if (!initContext.getOffsetMap().wasModified(CompletionInitializationContext.IDENTIFIER_END_OFFSET)) {
            try {
                int selectionEndOffset = initContext.getSelectionEndOffset();
                PsiReference reference2 = TargetElementUtil.findReference(this.myEditor, selectionEndOffset);
                if (reference2 != null) {
                    int replacementOffset = CompletionProgressIndicator.findReplacementOffset(selectionEndOffset, reference2);
                    if (replacementOffset > document.getTextLength()) {
                        LOG.error("Invalid replacementOffset: " + replacementOffset + " returned by reference " + reference2 + " of " + reference2.getClass() + "; doc=" + document + "; doc actual=" + (document == initContext.getFile().getViewProvider().getDocument()) + "; doc committed=" + PsiDocumentManager.getInstance((Project)this.getProject()).isCommitted(document));
                    } else {
                        initContext.setReplacementOffset(replacementOffset);
                    }
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        FileBasedIndex.getInstance().ignoreDumbMode(() -> {
            for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)initContext.getPositionLanguage(), (Project)initContext.getProject())) {
                ProgressManager.checkCanceled();
                contributor.duringCompletion(initContext);
            }
        }, DumbModeAccessType.RELIABLE_DATA_ONLY);
        if (document instanceof DocumentWindow) {
            this.myHostOffsets = new OffsetsInFile(initContext.getFile(), initContext.getOffsetMap()).toTopLevelFile();
        }
    }

    private void addDefaultAdvertisements(CompletionParameters parameters2) {
        if (DumbService.isDumb((Project)this.getProject())) {
            this.addAdvertisement(IdeBundle.message((String)"dumb.mode.results.might.be.incomplete", (Object[])new Object[0]), AllIcons.General.Warning);
            return;
        }
        String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItem");
        String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemReplace");
        this.addAdvertisement(CodeInsightBundle.message((String)"completion.ad.press.0.to.insert.1.to.replace", (Object[])new Object[]{enterShortcut, tabShortcut}), null);
        this.advertiseTabReplacement(parameters2);
        if (this.isAutopopupCompletion()) {
            if (CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters2) && !CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars()) {
                this.advertiseCtrlDot();
            }
            this.advertiseCtrlArrows();
        }
    }

    private void advertiseTabReplacement(CompletionParameters parameters2) {
        String shortcut;
        if (CompletionUtil.shouldShowFeature(parameters2, "editing.completion.replace") && this.myOffsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET) && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemReplace")))) {
            this.addAdvertisement(CodeInsightBundle.message((String)"completion.ad.use.0.to.overwrite", (Object[])new Object[]{shortcut}), null);
        }
    }

    private void advertiseCtrlDot() {
        String dotShortcut;
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.finishByCtrlDot", this.getProject()) && StringUtil.isNotEmpty((String)(dotShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemDot")))) {
            this.addAdvertisement(CodeInsightBundle.message((String)"completion.ad.press.0.to.choose.with.dot", (Object[])new Object[]{dotShortcut}), null);
        }
    }

    private void advertiseCtrlArrows() {
        if (!this.myEditor.isOneLineMode() && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.cancelByControlArrows", this.getProject())) {
            String downShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorLookupDown");
            String upShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorLookupUp");
            if (StringUtil.isNotEmpty((String)downShortcut) && StringUtil.isNotEmpty((String)upShortcut)) {
                this.addAdvertisement(CodeInsightBundle.message((String)"completion.ad.moving.caret.down.and.up.in.the.editor", (Object[])new Object[]{downShortcut, upShortcut}), null);
            }
        }
    }

    public void dispose() {
    }

    private static int findReplacementOffset(int selectionEndOffset, PsiReference reference2) {
        List ranges = ReferenceRange.getAbsoluteRanges((PsiReference)reference2);
        for (TextRange range2 : ranges) {
            if (!range2.contains(selectionEndOffset)) continue;
            return range2.getEndOffset();
        }
        return selectionEndOffset;
    }

    void scheduleAdvertising(CompletionParameters parameters2) {
        if (this.myLookup.isAvailableToUser()) {
            return;
        }
        FileBasedIndex.getInstance().ignoreDumbMode(() -> {
            for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters2)) {
                if (!this.myLookup.isCalculating() && !this.myLookup.isVisible()) {
                    return;
                }
                String s = contributor.advertise(parameters2);
                if (s == null) continue;
                this.addAdvertisement(s, null);
            }
        }, DumbModeAccessType.RELIABLE_DATA_ONLY);
    }

    private boolean isOutdated() {
        return CompletionServiceImpl.getCompletionPhase().indicator != this;
    }

    private void trackModifiers() {
        assert (!this.isAutopopupCompletion());
        JComponent contentComponent = this.myEditor.getContentComponent();
        contentComponent.addKeyListener(new ModifierTracker(contentComponent));
    }

    void setMergeCommand() {
        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)this.getCompletionCommandName());
    }

    @NonNls
    private String getCompletionCommandName() {
        return "Completion" + this.hashCode();
    }

    void showLookup() {
        this.updateLookup();
    }

    @Override
    @Nullable
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    @Override
    public void setParameters(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(6);
        }
        this.myParameters = parameters2;
    }

    @Override
    @NotNull
    public LookupImpl getLookup() {
        LookupImpl lookupImpl = this.myLookup;
        if (lookupImpl == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(7);
        }
        return lookupImpl;
    }

    void withSingleUpdate(Runnable action2) {
        this.myArranger.batchUpdate(action2);
    }

    private void updateLookup() {
        Runnable action2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isOutdated() || !this.shouldShowLookup()) {
            return;
        }
        while ((action2 = this.myAdvertiserChanges.poll()) != null) {
            action2.run();
        }
        if (!this.myLookupUpdated) {
            if (this.myLookup.getAdvertisements().isEmpty() && !this.isAutopopupCompletion() && !DumbService.isDumb((Project)this.getProject())) {
                DefaultCompletionContributor.addDefaultAdvertisements(this.myLookup, this.myHasPsiElements);
            }
            this.myLookup.getAdvertiser().showRandomText();
        }
        boolean justShown = false;
        if (!this.myLookup.isShown()) {
            if (this.hideAutopopupIfMeaningless()) {
                return;
            }
            if (!this.myLookup.showLookup()) {
                return;
            }
            justShown = true;
        }
        this.myLookupUpdated = true;
        this.myLookup.refreshUi(true, justShown);
        this.hideAutopopupIfMeaningless();
        if (justShown) {
            this.myLookup.ensureSelectionVisible(true);
        }
    }

    private boolean shouldShowLookup() {
        if (this.isAutopopupCompletion()) {
            if (this.myCount == 0) {
                return false;
            }
            if (this.myLookup.isCalculating() && Registry.is((String)"ide.completion.delay.autopopup.until.completed")) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItem(CompletionResult item) {
        boolean allowMiddleMatches;
        boolean forceMiddleMatch;
        if (!this.isRunning()) {
            return;
        }
        ProgressManager.checkCanceled();
        if (!this.myHandler.isTestingMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        LookupElement lookupElement = item.getLookupElement();
        if (!this.myHasPsiElements && lookupElement.getPsiElement() != null) {
            this.myHasPsiElements = true;
        }
        boolean bl = forceMiddleMatch = lookupElement.getUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH) != null;
        if (forceMiddleMatch) {
            this.myArranger.associateSorter(lookupElement, (CompletionSorterImpl)item.getSorter());
            this.addItemToLookup(item);
            return;
        }
        boolean bl2 = allowMiddleMatches = this.myCount > 10;
        if (allowMiddleMatches) {
            this.addDelayedMiddleMatches();
        }
        this.myArranger.associateSorter(lookupElement, (CompletionSorterImpl)item.getSorter());
        if (item.isStartMatch() || allowMiddleMatches) {
            this.addItemToLookup(item);
        } else {
            List<CompletionResult> list2 = this.myDelayedMiddleMatches;
            synchronized (list2) {
                this.myDelayedMiddleMatches.add(item);
            }
        }
    }

    private void addItemToLookup(CompletionResult item) {
        Ref stopRef = new Ref((Object)Boolean.FALSE);
        FileBasedIndex.getInstance().ignoreDumbMode(() -> stopRef.set((Object)(!this.myLookup.addItem(item.getLookupElement(), item.getPrefixMatcher()) ? 1 : 0)), DumbModeAccessType.RELIABLE_DATA_ONLY);
        if (((Boolean)stopRef.get()).booleanValue()) {
            return;
        }
        this.myArranger.setLastLookupPrefix(this.myLookup.getAdditionalPrefix());
        ++this.myCount;
        if (this.myCount == 1) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ((Semaphore)this.myFreezeSemaphore).up(), (long)ourInsertSingleItemTimeSpan, TimeUnit.MILLISECONDS);
        }
        this.myQueue.queue(this.myUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDelayedMiddleMatches() {
        ArrayList<CompletionResult> delayed;
        List<CompletionResult> list2 = this.myDelayedMiddleMatches;
        synchronized (list2) {
            if (this.myDelayedMiddleMatches.isEmpty()) {
                return;
            }
            delayed = new ArrayList<CompletionResult>(this.myDelayedMiddleMatches);
            this.myDelayedMiddleMatches.clear();
        }
        for (CompletionResult item : delayed) {
            ProgressManager.checkCanceled();
            this.addItemToLookup(item);
        }
    }

    public void closeAndFinish(boolean hideLookup) {
        LookupEx lookup2;
        if (!this.myLookup.isLookupDisposed() && (lookup2 = LookupManager.getActiveLookup(this.myEditor)) != null && lookup2 != this.myLookup) {
            LOG.error("lookup changed: " + lookup2 + "; " + this);
        }
        this.myLookup.removeLookupListener(this.myLookupListener);
        this.finishCompletionProcess(true);
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        if (hideLookup) {
            this.myLookup.hideLookup(true);
        }
    }

    private void finishCompletionProcess(boolean disposeOffsetMap) {
        this.cancel();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose((Disposable)this.myQueue);
        LookupManager.getInstance(this.getProject()).removePropertyChangeListener(this.myLookupManagerListener);
        CompletionServiceImpl.assertPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.Synchronous.class, CompletionPhase.CommittingDocuments.class);
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        LOG.assertTrue(currentCompletion == this, (Object)(currentCompletion + "!=" + this));
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            LOG.assertTrue(oldPhase.indicator != null, (Object)oldPhase);
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        if (disposeOffsetMap) {
            this.disposeIndicator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeIndicator() {
        Object object = this.myLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChildDisposable(@NotNull Supplier<? extends Disposable> child2) {
        if (child2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.checkCanceled();
            Disposer.register((Disposable)this, (Disposable)child2.get());
        }
    }

    @TestOnly
    public static void cleanupForNextTest() {
        CompletionService completionService = (CompletionService)ApplicationManager.getApplication().getServiceIfCreated(CompletionService.class);
        if (!(completionService instanceof CompletionServiceImpl)) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (currentCompletion != null) {
            currentCompletion.finishCompletionProcess(true);
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        } else {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        StatisticsUpdate.cancelLastCompletionStatisticsUpdate();
    }

    boolean blockingWaitForFinish(int timeoutMs) {
        if (this.myHandler.isTestingMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            if (!this.myFinishSemaphore.waitFor(100000L)) {
                throw new AssertionError((Object)"Too long completion");
            }
            return true;
        }
        if (this.myFreezeSemaphore.waitFor((long)timeoutMs)) {
            return !this.isRunning() && !this.isCanceled();
        }
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.myQueue.cancelAllUpdates();
        this.myFreezeSemaphore.up();
        this.myFinishSemaphore.up();
        GuiUtils.invokeLaterIfNeeded(() -> {
            PsiFile file2;
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            if (!(phase instanceof CompletionPhase.BgCalculation) || phase.indicator != this) {
                return;
            }
            LOG.assertTrue(!this.getProject().isDisposed(), (Object)"project disposed");
            if (this.myEditor.isDisposed()) {
                this.myLookup.hideLookup(false);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                return;
            }
            if (this.myEditor instanceof EditorWindow) {
                LOG.assertTrue(((EditorWindow)this.myEditor).getInjectedFile().isValid(), (Object)"injected file !valid");
                LOG.assertTrue(((DocumentWindow)this.myEditor.getDocument()).isValid(), (Object)"docWindow !valid");
            }
            LOG.assertTrue((file2 = this.myLookup.getPsiFile()) == null || file2.isValid(), (Object)"file !valid");
            this.myLookup.setCalculating(false);
            if (this.myCount == 0) {
                this.myLookup.hideLookup(false);
                if (!this.isAutopopupCompletion()) {
                    CompletionProgressIndicator current2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
                    LOG.assertTrue(current2 == null, (Object)(current2 + "!=" + this));
                    this.handleEmptyLookup(!((CompletionPhase.BgCalculation)phase).modifiersChanged);
                } else {
                    CompletionServiceImpl.setCompletionPhase(new CompletionPhase.EmptyAutoPopup(this.myEditor, this.myRestartingPrefixConditions));
                }
            } else {
                this.updateLookup();
                if (!CompletionServiceImpl.isPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.EmptyAutoPopup.class)) {
                    CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(this));
                }
            }
        }, (ModalityState)this.myQueue.getModalityState());
    }

    private boolean hideAutopopupIfMeaningless() {
        if (!this.myLookup.isLookupDisposed() && this.isAutopopupCompletion() && !this.myLookup.isSelectionTouched() && !this.myLookup.isCalculating()) {
            this.myLookup.refreshUi(true, false);
            List<LookupElement> items = this.myLookup.getItems();
            for (LookupElement item : items) {
                if (!this.isAlreadyInTheEditor(item)) {
                    return false;
                }
                if (!item.isValid() || !item.isWorthShowingInAutoPopup()) continue;
                return false;
            }
            this.myLookup.hideLookup(false);
            LOG.assertTrue(CompletionServiceImpl.getCompletionService().getCurrentCompletion() == null);
            CompletionServiceImpl.setCompletionPhase(new CompletionPhase.EmptyAutoPopup(this.myEditor, this.myRestartingPrefixConditions));
            return true;
        }
        return false;
    }

    private boolean isAlreadyInTheEditor(LookupElement item) {
        Editor editor = this.myLookup.getEditor();
        int start2 = editor.getCaretModel().getOffset() - this.myLookup.itemPattern(item).length();
        Document document = editor.getDocument();
        return start2 >= 0 && StringUtil.startsWith((CharSequence)document.getImmutableCharSequence().subSequence(start2, document.getTextLength()), (CharSequence)item.getLookupString());
    }

    void restorePrefix(@NotNull Runnable customRestore) {
        if (customRestore == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(9);
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), null, null, () -> {
            this.setMergeCommand();
            customRestore.run();
        }, (PsiFile[])new PsiFile[0]);
    }

    int nextInvocationCount(int invocation, boolean reused) {
        return reused ? Math.max(this.myInvocationCount + 1, 2) : invocation;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(10);
        }
        return editor;
    }

    @Override
    @NotNull
    public Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(11);
        }
        return caret;
    }

    boolean isRepeatedInvocation(CompletionType completionType, Editor editor) {
        if (completionType != this.myCompletionType || editor != this.myEditor) {
            return false;
        }
        return !this.isAutopopupCompletion() || this.myLookup.mayBeNoticed();
    }

    public boolean isAutopopupCompletion() {
        return this.myInvocationCount == 0;
    }

    int getInvocationCount() {
        return this.myInvocationCount;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = Objects.requireNonNull(this.myEditor.getProject());
        if (project == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(12);
        }
        return project;
    }

    @Override
    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
        this.myRestartingPrefixConditions.add((Pair<Integer, ElementPattern<String>>)Pair.create((Object)startOffset, restartCondition));
    }

    @Override
    public void prefixUpdated() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        if (caretOffset < this.myStartCaret) {
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        if (CompletionProgressIndicator.shouldRestartCompletion(this.myEditor, this.myRestartingPrefixConditions, "")) {
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        this.hideAutopopupIfMeaningless();
    }

    @ApiStatus.Internal
    public static boolean shouldRestartCompletion(@NotNull Editor editor, @NotNull Set<Pair<Integer, ElementPattern<String>>> restartingPrefixConditions, @NotNull String toAppend) {
        if (editor == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(13);
        }
        if (restartingPrefixConditions == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(14);
        }
        if (toAppend == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(15);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text2 = editor.getDocument().getCharsSequence();
        for (Pair<Integer, ElementPattern<String>> pair : restartingPrefixConditions) {
            String newPrefix;
            int start2 = (Integer)pair.first;
            if (caretOffset < start2 || start2 < 0 || caretOffset > text2.length() || !((ElementPattern)pair.second).accepts((Object)(newPrefix = text2.subSequence(start2, caretOffset).toString() + toAppend))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void scheduleRestart() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHandler.isTestingMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            this.closeAndFinish(false);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            new CodeCompletionHandlerBase(this.myCompletionType, false, false, true).invokeCompletion(this.getProject(), this.myEditor, this.myInvocationCount);
            return;
        }
        this.cancel();
        CompletionProgressIndicator current2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (this != current2) {
            LOG.error(current2 + "!=" + this);
        }
        this.hideAutopopupIfMeaningless();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionPhase.CommittingDocuments.scheduleAsyncCompletion(this.myEditor, this.myCompletionType, null, this.getProject(), this);
    }

    @Override
    public String toString() {
        return "CompletionProgressIndicator[count=" + this.myCount + ",phase=" + CompletionServiceImpl.getCompletionPhase() + "]@" + System.identityHashCode(this);
    }

    void handleEmptyLookup(boolean awaitSecondInvocation) {
        if (this.isAutopopupCompletion() && ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.assertTrue(!this.isAutopopupCompletion());
        CompletionParameters parameters2 = this.getParameters();
        if (this.myHandler.invokedExplicitly && parameters2 != null) {
            LightweightHint hint = this.showErrorHint(this.getProject(), this.getEditor(), this.getNoSuggestionsMessage(parameters2));
            if (awaitSecondInvocation) {
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.NoSuggestionsHint(hint, this));
                return;
            }
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
    }

    @NlsContexts.HintText
    private String getNoSuggestionsMessage(CompletionParameters parameters2) {
        return (String)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> CompletionContributor.forParameters((CompletionParameters)parameters2).stream().map(c -> c.handleEmptyLookup(parameters2, this.getEditor())).filter(StringUtil::isNotEmpty).findFirst().orElse(LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LightweightHint showErrorHint(Project project, Editor editor, @NlsContexts.HintText String text2) {
        LightweightHint[] result2 = new LightweightHint[]{null};
        EditorHintListener listener2 = (project1, hint, flags) -> {
            result2[0] = hint;
        };
        SimpleMessageBusConnection connection = project.getMessageBus().simpleConnect();
        try {
            connection.subscribe(EditorHintListener.TOPIC, (Object)listener2);
            assert (text2 != null);
            this.myEmptyCompletionNotifier.showIncompleteHint(editor, text2, DumbService.isDumb((Project)project));
        }
        finally {
            connection.disconnect();
        }
        return result2[0];
    }

    private static boolean shouldPreselectFirstSuggestion(CompletionParameters parameters2) {
        if (Registry.is((String)"ide.completion.lookup.element.preselect.depends.on.context")) {
            for (CompletionPreselectionBehaviourProvider provider2 : CompletionPreselectionBehaviourProvider.EP_NAME.getExtensionList()) {
                if (provider2.shouldPreselectFirstSuggestion(parameters2)) continue;
                return false;
            }
        }
        return true;
    }

    void runContributors(CompletionInitializationContext initContext) {
        CompletionParameters parameters2 = Objects.requireNonNull(this.myParameters);
        this.myThreading.startThread(ProgressWrapper.wrap(this), () -> AsyncCompletion.tryReadOrCancel(this, () -> this.scheduleAdvertising(parameters2)));
        WeighingDelegate weigher2 = this.myThreading.delegateWeighing(this);
        try {
            this.calculateItems(initContext, weigher2, parameters2);
        }
        catch (ProcessCanceledException ignore) {
            this.cancel();
        }
        catch (Throwable t) {
            this.cancel();
            LOG.error(t);
        }
    }

    private void calculateItems(CompletionInitializationContext initContext, WeighingDelegate weigher2, CompletionParameters parameters2) {
        FileBasedIndex.getInstance().ignoreDumbMode(() -> {
            this.duringCompletion(initContext, parameters2);
            ProgressManager.checkCanceled();
            CompletionService.getCompletionService().performCompletion(parameters2, (Consumer)weigher2);
        }, DumbModeAccessType.RELIABLE_DATA_ONLY);
        ProgressManager.checkCanceled();
        weigher2.waitFor();
        ProgressManager.checkCanceled();
    }

    @NotNull
    CompletionThreadingBase getCompletionThreading() {
        CompletionThreadingBase completionThreadingBase = this.myThreading;
        if (completionThreadingBase == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(16);
        }
        return completionThreadingBase;
    }

    @Override
    public void addAdvertisement(@NotNull String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(17);
        }
        this.myAdvertiserChanges.offer(() -> this.myLookup.addAdvertisement(text2, icon2));
        this.myQueue.queue(this.myUpdate);
    }

    @TestOnly
    public static void setGroupingTimeSpan(int timeSpan) {
        ourInsertSingleItemTimeSpan = timeSpan;
    }

    @Deprecated
    public static void setAutopopupTriggerTime(int timeSpan) {
        ourShowPopupGroupingTime = timeSpan;
        ourShowPopupAfterFirstItemGroupingTime = timeSpan;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRestore";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restartingPrefixConditions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAppend";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostOffsets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionThreading";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerChildDisposable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restorePrefix";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestartCompletion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAdvertisement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectEmptyCompletionNotifier
    implements EmptyCompletionNotifier {
        private ProjectEmptyCompletionNotifier() {
        }

        @Override
        public void showIncompleteHint(@NotNull Editor editor, @NotNull @NlsContexts.HintText String text2, boolean isDumbMode) {
            if (editor == null) {
                ProjectEmptyCompletionNotifier.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ProjectEmptyCompletionNotifier.$$$reportNull$$$0(1);
            }
            String message = isDumbMode ? text2 + CodeInsightBundle.message((String)"completion.incomplete.during.indexing.suffix", (Object[])new Object[0]) : text2;
            HintManager.getInstance().showInformationHint(editor, StringUtil.escapeXmlEntities((String)message), (short)2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/CompletionProgressIndicator$ProjectEmptyCompletionNotifier";
            objectArray[2] = "showIncompleteHint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModifierTracker
    extends KeyAdapter {
        private final JComponent myContentComponent;

        ModifierTracker(JComponent contentComponent) {
            this.myContentComponent = contentComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processModifier(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processModifier(e);
        }

        private void processModifier(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 17 || code == 157 || code == 18 || code == 16) {
                this.myContentComponent.removeKeyListener(this);
                CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
                if (phase instanceof CompletionPhase.BgCalculation) {
                    ((CompletionPhase.BgCalculation)phase).modifiersChanged = true;
                } else if (phase instanceof CompletionPhase.InsertedSingleItem) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        }
    }
}

