/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class FileTreeIterator {
    private Queue<PsiFile> myCurrentFiles;
    private Queue<PsiDirectory> myCurrentDirectories;

    public FileTreeIterator(@NotNull List<? extends PsiFile> files2) {
        if (files2 == null) {
            FileTreeIterator.$$$reportNull$$$0(0);
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentFiles.addAll(files2);
    }

    public FileTreeIterator(@NotNull Module module) {
        if (module == null) {
            FileTreeIterator.$$$reportNull$$$0(1);
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.addAll(FileTreeIterator.collectModuleDirectories(module));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull Project project) {
        if (project == null) {
            FileTreeIterator.$$$reportNull$$$0(2);
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.addAll(FileTreeIterator.collectProjectDirectories(project));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    @NotNull
    public static List<PsiDirectory> collectProjectDirectories(@NotNull Project project) {
        Module[] modules2;
        if (project == null) {
            FileTreeIterator.$$$reportNull$$$0(3);
        }
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
        for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
            directories.addAll(FileTreeIterator.collectModuleDirectories(module));
        }
        ArrayList<PsiDirectory> arrayList = directories;
        if (arrayList == null) {
            FileTreeIterator.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public FileTreeIterator(@NotNull PsiDirectory directory) {
        if (directory == null) {
            FileTreeIterator.$$$reportNull$$$0(5);
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.add(directory);
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull FileTreeIterator fileTreeIterator) {
        if (fileTreeIterator == null) {
            FileTreeIterator.$$$reportNull$$$0(6);
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentFiles = new LinkedList<PsiFile>(fileTreeIterator.myCurrentFiles);
        this.myCurrentDirectories = new LinkedList<PsiDirectory>(fileTreeIterator.myCurrentDirectories);
    }

    @NotNull
    public PsiFile next() {
        if (this.myCurrentFiles.isEmpty()) {
            throw new NoSuchElementException();
        }
        PsiFile current2 = this.myCurrentFiles.poll();
        this.expandDirectoriesUntilFilesNotEmpty();
        PsiFile psiFile = current2;
        if (psiFile == null) {
            FileTreeIterator.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    public boolean hasNext() {
        return !this.myCurrentFiles.isEmpty();
    }

    private void expandDirectoriesUntilFilesNotEmpty() {
        while (this.myCurrentFiles.isEmpty() && !this.myCurrentDirectories.isEmpty()) {
            PsiDirectory dir = this.myCurrentDirectories.poll();
            this.expandDirectory(dir);
        }
    }

    private void expandDirectory(@NotNull PsiDirectory dir) {
        if (dir == null) {
            FileTreeIterator.$$$reportNull$$$0(8);
        }
        Collections.addAll(this.myCurrentFiles, dir.getFiles());
        Collections.addAll(this.myCurrentDirectories, dir.getSubdirectories());
    }

    @NotNull
    public static List<PsiDirectory> collectModuleDirectories(Module module) {
        VirtualFile[] contentRoots;
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)module.getProject()).findDirectory(root);
            if (dir == null) continue;
            dirs.add(dir);
        }
        ArrayList<PsiDirectory> arrayList = dirs;
        if (arrayList == null) {
            FileTreeIterator.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FileTreeIterator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTreeIterator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FileTreeIterator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectModuleDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectDirectories";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

