/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;

public abstract class TextMateService {
    protected static final Logger LOG = Logger.getInstance(TextMateService.class);

    public static TextMateService getInstance() {
        return (TextMateService)ApplicationManager.getApplication().getService(TextMateService.class);
    }

    @Nullable
    public abstract Bundle createBundle(@NotNull VirtualFile var1);

    public abstract void reloadEnabledBundles();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void registerEnabledBundles(boolean builtin) {
        this.reloadEnabledBundles();
    }

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence var1);

    @Nullable
    public abstract TextMateShellVariable getVariable(@NotNull String var1, @NotNull EditorEx var2);

    @NotNull
    public abstract SnippetsRegistry getSnippetsRegistry();

    @NotNull
    public abstract PreferencesRegistry getPreferencesRegistry();

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence var1);

    @NotNull
    public abstract Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors();
}

