/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import io.netty.buffer.ByteBuf;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.integratedBinaryPacking.LongBitPacker;
import org.jetbrains.mvstore.type.DataType;

final class MapMetadata {
    final int id;
    final long createVersion;

    MapMetadata(int id, long createVersion) {
        this.id = id;
        this.createVersion = createVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMetadata value = (MapMetadata)o;
        return this.id == value.id && this.createVersion == value.createVersion;
    }

    public int hashCode() {
        return 31 * this.id + (int)(this.createVersion ^ this.createVersion >>> 32);
    }

    public String toString() {
        return "MapMetadata(id=" + this.id + ", createVersion=" + this.createVersion + ")";
    }

    static final class MapMetadataSerializer
    implements DataType<MapMetadata> {
        MapMetadataSerializer() {
        }

        public MapMetadata[] createStorage(int size) {
            return new MapMetadata[size];
        }

        @Override
        public int getMemory(MapMetadata obj) {
            return this.getFixedMemory();
        }

        @Override
        public int getFixedMemory() {
            return 14;
        }

        @Override
        public void write(ByteBuf buf, MapMetadata obj) {
            IntBitPacker.writeVar(buf, obj.id);
            LongBitPacker.writeVar(buf, obj.createVersion);
        }

        @Override
        public MapMetadata read(ByteBuf buf) {
            return new MapMetadata(IntBitPacker.readVar(buf), LongBitPacker.readVar(buf));
        }
    }
}

