/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.VisibleForTesting;

public class ShortAssert
extends GenericAssert<ShortAssert, Short>
implements NumberAssert {
    private static final short ZERO = 0;

    @VisibleForTesting
    ShortAssert(int actual) {
        this((short)actual);
    }

    protected ShortAssert(short actual) {
        super(ShortAssert.class, actual);
    }

    protected ShortAssert(@Nullable Short actual) {
        super(ShortAssert.class, actual);
    }

    @Override
    @Nonnull
    public ShortAssert isEqualTo(short expected) {
        return (ShortAssert)this.isEqualTo(Short.valueOf(expected));
    }

    @Override
    @Nonnull
    public ShortAssert isNotEqualTo(short other) {
        return (ShortAssert)this.isNotEqualTo(Short.valueOf(other));
    }

    @Nonnull
    public ShortAssert isGreaterThan(short other) {
        if ((Short)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public ShortAssert isLessThan(short other) {
        if ((Short)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public ShortAssert isGreaterThanOrEqualTo(short other) {
        if ((Short)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    @Nonnull
    public ShortAssert isLessThanOrEqualTo(short other) {
        if ((Short)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    @Nonnull
    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }

    @Override
    @Nonnull
    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    @Override
    @Nonnull
    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }
}

