/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;

public class CharAssert
extends GenericAssert<CharAssert, Character> {
    protected CharAssert(char actual) {
        super(CharAssert.class, Character.valueOf(actual));
    }

    protected CharAssert(Character actual) {
        super(CharAssert.class, actual);
    }

    @Override
    @Nonnull
    public CharAssert isEqualTo(char expected) {
        return (CharAssert)this.isEqualTo(Character.valueOf(expected));
    }

    @Override
    @Nonnull
    public CharAssert isNotEqualTo(char other) {
        return (CharAssert)this.isNotEqualTo(Character.valueOf(other));
    }

    @Nonnull
    public CharAssert isGreaterThan(char other) {
        if (((Character)this.actual).charValue() > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    @Nonnull
    public CharAssert isLessThan(char other) {
        if (((Character)this.actual).charValue() < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    @Nonnull
    public CharAssert isGreaterThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Character.valueOf(other)));
    }

    @Nonnull
    public CharAssert isLessThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Character.valueOf(other)));
    }

    @Nonnull
    public CharAssert isUpperCase() {
        if (Character.isUpperCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(String.format("<%s> should be an upper-case character", this.actual));
    }

    @Nonnull
    public CharAssert isLowerCase() {
        if (Character.isLowerCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(String.format("<%s> should be a lower-case character", this.actual));
    }
}

