/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class ByteArrayAssert
extends ArrayAssert<ByteArrayAssert, byte[]> {
    protected ByteArrayAssert(byte ... actual) {
        super(ByteArrayAssert.class, actual);
    }

    @Nonnull
    public ByteArrayAssert contains(byte ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public ByteArrayAssert containsOnly(byte ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public ByteArrayAssert excludes(byte ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public ByteArrayAssert isEqualTo(@Nullable byte[] expected) {
        if (Arrays.equals((byte[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public ByteArrayAssert isNotEqualTo(@Nullable byte[] array) {
        if (!Arrays.equals((byte[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

