/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexpValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final NullableLazyValue<Pattern> myPattern;
    @Nullable
    private final String myRegexp;
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "[", "]", "{", "}", "(", ")", "-", "^", "*", "+", "?", ".", "|", "$");
    private static final List<String> ESCAPE_TO = ContainerUtil.map(ESCAPE_FROM, s -> "\\" + s);

    public RegexpValidationRule(final @Nullable String regexp) {
        this.myPattern = regexp == null ? null : new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                try {
                    return Pattern.compile(regexp);
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        };
        this.myRegexp = regexp;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Pattern pattern;
        if (data == null) {
            RegexpValidationRule.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RegexpValidationRule.$$$reportNull$$$0(1);
        }
        if ((pattern = (Pattern)this.myPattern.getValue()) == null) {
            ValidationResultType validationResultType = ValidationResultType.INCORRECT_RULE;
            if (validationResultType == null) {
                RegexpValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue((String)data);
        if (pattern.matcher(escaped).matches()) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                RegexpValidationRule.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }
        String legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded((String)escaped);
        ValidationResultType validationResultType = legacyData != null && pattern.matcher(legacyData).matches() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        if (validationResultType == null) {
            RegexpValidationRule.$$$reportNull$$$0(4);
        }
        return validationResultType;
    }

    @Override
    @NotNull
    public String asRegexp() {
        return this.myRegexp != null ? this.myRegexp : "<invalid>";
    }

    public String toString() {
        return "RegexpValidationRule: myRegexp=" + this.asRegexp();
    }

    public static String escapeText(@NotNull String text) {
        if (text == null) {
            RegexpValidationRule.$$$reportNull$$$0(5);
        }
        return StringUtil.replace((String)text, ESCAPE_FROM, ESCAPE_TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

