/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.logger;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.logger.EventsRateResult;
import com.intellij.internal.statistic.eventLog.logger.EventsRateResultType;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsIdentityWindowThrottle;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/eventLog/logger/StatisticsEventLogThrottleWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "configOptionsService", "Lcom/intellij/internal/statistic/eventLog/EventLogConfigOptionsService;", "recorderId", "", "recorderVersion", "delegate", "(Lcom/intellij/internal/statistic/eventLog/EventLogConfigOptionsService;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;)V", "ourGroupThrottle", "Lcom/intellij/internal/statistic/utils/EventsIdentityWindowThrottle;", "ourLock", "", "ourThrottle", "Lcom/intellij/internal/statistic/utils/EventsRateWindowThrottle;", "cleanup", "", "copyEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "eventId", "groupId", "groupVersion", "logEvent", "dispose", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "getOrDefault", "", "value", "defaultValue", "log", "rollOver", "tryPass", "Lcom/intellij/internal/statistic/eventLog/logger/EventsRateResult;", "group", "now", "", "intellij.platform.statistics"})
public final class StatisticsEventLogThrottleWriter
implements StatisticsEventLogWriter {
    private final Object ourLock;
    private final EventsRateWindowThrottle ourThrottle;
    private final EventsIdentityWindowThrottle ourGroupThrottle;
    private final String recorderVersion;
    private final StatisticsEventLogWriter delegate;

    private final int getOrDefault(int value, int defaultValue) {
        return value > 0 ? value : defaultValue;
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        EventsRateResult shouldLog = this.tryPass(logEvent.getGroup().getId(), System.currentTimeMillis());
        if (shouldLog.getType() == EventsRateResultType.ALERT_GROUP) {
            LogEvent alert = this.copyEvent("validation.too_many_events.alert", logEvent.getGroup().getId(), logEvent.getGroup().getVersion(), logEvent);
            this.delegate.log(alert);
            this.delegate.log(logEvent);
            return;
        }
        if (shouldLog.getType() == EventsRateResultType.ACCEPTED) {
            this.delegate.log(logEvent);
            return;
        }
        if (shouldLog.getReport()) {
            String errorGroupId = shouldLog.getType() == EventsRateResultType.DENIED_TOTAL ? "event.log" : logEvent.getGroup().getId();
            String errorGroupVersion = shouldLog.getType() == EventsRateResultType.DENIED_TOTAL ? this.recorderVersion : logEvent.getGroup().getVersion();
            LogEvent event = this.copyEvent("validation.too_many_events", errorGroupId, errorGroupVersion, logEvent);
            this.delegate.log(event);
            return;
        }
    }

    private final LogEvent copyEvent(String eventId, String groupId, String groupVersion, LogEvent logEvent) {
        return new LogEvent(logEvent.getSession(), logEvent.getBuild(), logEvent.getBucket(), logEvent.getTime(), groupId, groupVersion, logEvent.getRecorderVersion(), new LogEventAction(eventId, logEvent.getEvent().getState(), 0, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EventsRateResult tryPass(String group, long now) {
        Object object = this.ourLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block8: {
                EventRateThrottleResult groupResult;
                block7: {
                    block6: {
                        boolean bl3 = false;
                        EventRateThrottleResult result = this.ourThrottle.tryPass(now);
                        if (result.isAccept()) break block6;
                        boolean report = result == EventRateThrottleResult.DENY_AND_REPORT;
                        EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.DENIED_TOTAL, report);
                        return eventsRateResult;
                    }
                    groupResult = this.ourGroupThrottle.tryPass(group, now);
                    if (groupResult.isAccept()) break block7;
                    boolean report = groupResult == EventRateThrottleResult.DENY_AND_REPORT;
                    EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.DENIED_GROUP, report);
                    return eventsRateResult;
                }
                if (groupResult != EventRateThrottleResult.ALERT) break block8;
                EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.ALERT_GROUP, true);
                return eventsRateResult;
            }
            EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.ACCEPTED, false);
            return eventsRateResult;
        }
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        return this.delegate.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.delegate.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public void rollOver() {
        this.delegate.rollOver();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.delegate);
    }

    public StatisticsEventLogThrottleWriter(@NotNull EventLogConfigOptionsService configOptionsService, final @NotNull String recorderId, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter delegate) {
        Intrinsics.checkNotNullParameter((Object)configOptionsService, (String)"configOptionsService");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.recorderVersion = recorderVersion;
        this.delegate = delegate;
        this.ourLock = new Object();
        int threshold = this.getOrDefault(configOptionsService.getThreshold(recorderId), 24000);
        this.ourThrottle = new EventsRateWindowThrottle(threshold, 3600000L, System.currentTimeMillis());
        int groupThreshold = this.getOrDefault(configOptionsService.getGroupThreshold(recorderId), 12000);
        int groupAlertThreshold = this.getOrDefault(configOptionsService.getGroupAlertThreshold(recorderId), 6000);
        this.ourGroupThrottle = new EventsIdentityWindowThrottle(groupThreshold, groupAlertThreshold, 3600000L);
        Topic<EventLogConfigOptionsService.EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"EventLogConfigOptionsService.TOPIC");
        Topics.subscribe(topic, (Disposable)this, (Object)new EventLogConfigOptionsService.EventLogThresholdConfigOptionsListener(recorderId){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        ourThrottle.setThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        ourGroupThrottle.setThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupAlertThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        ourGroupThrottle.setAlertThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        });
    }
}

