/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public abstract class HgBaseLogParser<CommitT>
implements Function<String, CommitT> {
    private static final Logger LOG = Logger.getInstance(HgBaseLogParser.class);
    private static final int REVISION_INDEX = 0;
    private static final int CHANGESET_INDEX = 1;
    private static final int PARENTS_INDEX = 2;
    private static final int DATE_INDEX = 3;
    private static final int AUTHOR_INDEX = 4;
    protected static final int MESSAGE_INDEX = 5;
    protected static final int BRANCH_INDEX = 6;
    protected static final int FILES_ADDED_INDEX = 7;
    protected static final int FILES_MODIFIED_INDEX = 8;
    protected static final int FILES_DELETED_INDEX = 9;
    protected static final int FILES_COPIED_INDEX = 10;

    @Nullable
    public CommitT convert(@NotNull String line) {
        List attributes;
        int numAttributes;
        if (line == null) {
            HgBaseLogParser.$$$reportNull$$$0(0);
        }
        if ((numAttributes = (attributes = StringUtil.split((String)line, (String)"\u0017", (boolean)true, (boolean)false)).size()) <= 4) {
            LOG.info("Hg Log Command was cancelled or failed");
            return null;
        }
        try {
            String revisionString = (String)attributes.get(0);
            String changeset = (String)attributes.get(1);
            String parentsString = (String)attributes.get(2);
            SmartList<HgRevisionNumber> parents = HgBaseLogParser.parseParentRevisions(parentsString, revisionString);
            String unixTimeStamp = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)((String)attributes.get(3)), (String)" "));
            if (unixTimeStamp == null) {
                LOG.warn("Error parsing date in line " + line);
                return null;
            }
            Date revisionDate = new Date(Long.parseLong(unixTimeStamp.trim()) * 1000L);
            Couple<String> authorAndEmail = HgUtil.parseUserNameAndEmail((String)attributes.get(4));
            return this.convertDetails(revisionString, changeset, parents, revisionDate, (String)authorAndEmail.first, (String)authorAndEmail.second, attributes);
        }
        catch (NumberFormatException e) {
            LOG.warn("Error parsing rev in line " + line);
            return null;
        }
    }

    public CommitT fun(String s) {
        return this.convert(s);
    }

    @Nullable
    protected abstract CommitT convertDetails(@NotNull String var1, @NotNull String var2, @NotNull SmartList<? extends HgRevisionNumber> var3, @NotNull Date var4, @NotNull String var5, @NotNull String var6, @NotNull List<String> var7);

    @NotNull
    public static List<String> constructDefaultTemplate(HgVersion currentVersion) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|hgdate}", "{author}"));
        ArrayList<String> arrayList = templates;
        if (arrayList == null) {
            HgBaseLogParser.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static String @NotNull [] constructFullTemplateArgument(boolean includeFiles, @NotNull HgVersion currentVersion) {
        if (currentVersion == null) {
            HgBaseLogParser.$$$reportNull$$$0(2);
        }
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|hgdate}", "{author}", "{desc}", "{branch}"));
        if (!includeFiles) {
            String[] stringArray = ArrayUtilRt.toStringArray(templates);
            if (stringArray == null) {
                HgBaseLogParser.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        ArrayList fileTemplates = ContainerUtil.newArrayList((Object[])new String[]{"file_adds", "file_mods", "file_dels", "file_copies"});
        templates.addAll(HgBaseLogParser.wrapIn(fileTemplates, currentVersion));
        String[] stringArray = ArrayUtilRt.toStringArray(templates);
        if (stringArray == null) {
            HgBaseLogParser.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    private static List<String> wrapIn(@NotNull List<String> fileTemplates, @NotNull HgVersion currentVersion) {
        if (fileTemplates == null) {
            HgBaseLogParser.$$$reportNull$$$0(5);
        }
        if (currentVersion == null) {
            HgBaseLogParser.$$$reportNull$$$0(6);
        }
        boolean supported = currentVersion.isBuiltInFunctionSupported();
        List list = ContainerUtil.map(fileTemplates, s -> supported ? StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{join(\u0001,'\u0002')}", "\u0001"}, (String)s) : "{" + s + "}");
        if (list == null) {
            HgBaseLogParser.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected static SmartList<HgRevisionNumber> parseParentRevisions(@NotNull String parentsString, @NotNull String currentRevisionString) {
        if (parentsString == null) {
            HgBaseLogParser.$$$reportNull$$$0(8);
        }
        if (currentRevisionString == null) {
            HgBaseLogParser.$$$reportNull$$$0(9);
        }
        SmartList parents = new SmartList();
        if (StringUtil.isEmptyOrSpaces((String)parentsString)) {
            long revision = Long.parseLong(currentRevisionString);
            HgRevisionNumber parentRevision = HgRevisionNumber.getLocalInstance(String.valueOf(revision - 1L));
            parents.add((Object)parentRevision);
            SmartList smartList = parents;
            if (smartList == null) {
                HgBaseLogParser.$$$reportNull$$$0(10);
            }
            return smartList;
        }
        List parentStrings = StringUtil.split((String)parentsString.trim(), (String)" ");
        for (String parentString : parentStrings) {
            List parentParts = StringUtil.split((String)parentString, (String)":");
            if (Integer.valueOf((String)parentParts.get(0)) < 0) continue;
            parents.add((Object)HgRevisionNumber.getInstance((String)parentParts.get(0), (String)parentParts.get(1)));
        }
        SmartList smartList = parents;
        if (smartList == null) {
            HgBaseLogParser.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @NotNull
    protected static String parseAdditionalStringAttribute(List<String> attributes, int index) {
        int numAttributes = attributes.size();
        if (numAttributes > index) {
            String string = attributes.get(index);
            if (string == null) {
                HgBaseLogParser.$$$reportNull$$$0(12);
            }
            return string;
        }
        LOG.warn("Couldn't parse hg log commit info attribute " + index);
        return "";
    }

    @NotNull
    public static String extractSubject(@NotNull String message) {
        int subjectIndex;
        if (message == null) {
            HgBaseLogParser.$$$reportNull$$$0(13);
        }
        String string = (subjectIndex = message.indexOf(10)) == -1 ? message : message.substring(0, subjectIndex);
        if (string == null) {
            HgBaseLogParser.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgBaseLogParser";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTemplates";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentsString";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevisionString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgBaseLogParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDefaultTemplate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFullTemplateArgument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapIn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParentRevisions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAdditionalStringAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "constructFullTemplateArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapIn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseParentRevisions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractSubject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

