/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ngram;

import com.intellij.completion.ml.ngram.NGram;
import com.intellij.completion.ml.ngram.NGramModelRunnerManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/completion/ml/ngram/NGramFileListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeFileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.completionMlRanking"})
public final class NGramFileListener
implements FileEditorManagerListener.Before {
    private final Project project;
    private static final ExecutorService executor;
    private static final Companion Companion;

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026.findFile(file) ?: return");
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"psiFile.language");
        Language language2 = language;
        if (!NGram.INSTANCE.isSupported$intellij_completionMlRanking(language2)) {
            return;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiFile2));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"SmartPointerManager.createPointer(psiFile)");
        SmartPsiElementPointer filePointer = smartPsiElementPointer;
        ReadAction.nonBlocking((Runnable)new Runnable(this, filePointer, language2){
            final /* synthetic */ NGramFileListener this$0;
            final /* synthetic */ SmartPsiElementPointer $filePointer;
            final /* synthetic */ Language $language;

            public final void run() {
                NGramModelRunnerManager.Companion.getInstance(NGramFileListener.access$getProject$p(this.this$0)).processFile((SmartPsiElementPointer<PsiFile>)this.$filePointer, this.$language);
                SmartPointerManager.getInstance((Project)NGramFileListener.access$getProject$p(this.this$0)).removePointer(this.$filePointer);
            }
            {
                this.this$0 = nGramFileListener;
                this.$filePointer = smartPsiElementPointer;
                this.$language = language;
            }
        }).inSmartMode(this.project).submit((Executor)executor);
    }

    public NGramFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"N-grams for recent files");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026-grams for recent files\")");
        executor = executorService;
    }

    public static final /* synthetic */ Project access$getProject$p(NGramFileListener $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ml/ngram/NGramFileListener$Companion;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

