/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.images.util.ImageInfo;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageInfoIndex {
    private static final long ourMaxImageSize = (long)(Registry.get((String)"ide.index.image.max.size").asDouble() * 1024.0 * 1024.0);
    private static final DataExternalizer<ImageInfo> ourValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(@NotNull DataOutput out, ImageInfo info) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.width);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.height);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.bpp);
        }

        public ImageInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new ImageInfo(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/images/index/ImageInfoIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final VirtualFileGist<ImageInfo> ourGist = GistManager.getInstance().newVirtualFileGist("ImageInfo", 1, ourValueExternalizer, (project, file) -> {
        byte[] content;
        if (!file.isInLocalFileSystem() || file.getLength() > ourMaxImageSize) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType != SvgFileType.INSTANCE && fileType != ImageFileTypeManager.getInstance().getImageFileType()) {
            return null;
        }
        try {
            content = file.contentsToByteArray();
        }
        catch (IOException e) {
            Logger.getInstance(ImageInfoIndex.class).error((Throwable)e);
            return null;
        }
        ImageInfoReader.Info info = ImageInfoReader.getInfo(content);
        return info == null ? null : new ImageInfo(info.width, info.height, info.bpp);
    });

    @Nullable
    public static ImageInfo getInfo(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ImageInfoIndex.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ImageInfoIndex.$$$reportNull$$$0(1);
        }
        return (ImageInfo)ourGist.getFileData(project, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/intellij/images/index/ImageInfoIndex";
        objectArray[2] = "getInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

