/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.rules.en.UnitConversionRule;
import tech.units.indriya.unit.Units;

public class UnitConversionRuleUS
extends UnitConversionRule {
    public UnitConversionRuleUS(ResourceBundle messages) {
        super(messages);
        this.format = NumberFormat.getNumberInstance(Locale.US);
        this.format.setMaximumFractionDigits(2);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.addUnit("(kilometre|kilometer)s? per hour", Units.KILOMETRE_PER_HOUR, "kilometers per hour", 1.0, true);
        this.addUnit("kilomet(re|er)s?", Units.METRE, "kilometers", 1000.0, true);
        this.addUnit("met(re|er)s?", Units.METRE, "meters", 1.0, true);
        this.addUnit("decimet(re|er)s?", Units.METRE, "decimeters", 0.1, false);
        this.addUnit("centimet(re|er)s?", Units.METRE, "centimeters", 0.01, true);
        this.addUnit("millimet(re|er)s?", Units.METRE, "micrometers", 0.001, true);
        this.addUnit("micromet(re|er)s?", Units.METRE, "micrometers", 1.0E-6, true);
        this.addUnit("nanomet(re|er)s?", Units.METRE, "nanometers", 1.0E-9, true);
        this.addUnit("square met(re|er)s?", Units.SQUARE_METRE, "square meters", 1.0, true);
        this.addUnit("square kilomet(re|er)s?", Units.SQUARE_METRE, "square kilometers", 1000000.0, true);
        this.addUnit("square decimet(re|er)s?", Units.SQUARE_METRE, "square decimeters", 0.01, false);
        this.addUnit("square centimet(re|er)s?", Units.SQUARE_METRE, "square centimeters", 1.0E-4, true);
        this.addUnit("square millimet(re|er)s?", Units.SQUARE_METRE, "square millimeters", 1.0E-6, true);
        this.addUnit("square micromet(re|er)s?", Units.SQUARE_METRE, "square micrometers", 1.0E-12, true);
        this.addUnit("square nanomet(re|er)s?", Units.SQUARE_METRE, "square nanometers", 1.0E-18, true);
        this.addUnit("cubic met(re|er)s?", Units.CUBIC_METRE, "cubic meters", 1.0, true);
        this.addUnit("cubic kilomet(re|er)s?", Units.CUBIC_METRE, "cubic kilometers", 1.0E9, true);
        this.addUnit("cubic decimet(re|er)s?", Units.CUBIC_METRE, "cubic decimeters", 0.001, false);
        this.addUnit("cubic centimet(re|er)s?", Units.CUBIC_METRE, "cubic centimeters", 1.0E-6, true);
        this.addUnit("cubic millimet(re|er)s?", Units.CUBIC_METRE, "cubic millimeters", 1.0E-9, true);
        this.addUnit("cubic micromet(re|er)s?", Units.CUBIC_METRE, "cubic micrometers", 1.0E-18, true);
        this.addUnit("cubic nanomet(re|er)s?", Units.CUBIC_METRE, "cubic nanometers", 1.0E-27, true);
        this.addUnit("lit(re|er)s?", Units.LITRE, "liters", 1.0, true);
        this.addUnit("millilit(re|er)s?", Units.LITRE, "milliliters", 0.001, true);
        this.addUnit("qt\\.", US_QUART, "qt.", 1.0, false);
        this.addUnit("gal", US_GALLON, "gal", 1.0, false);
        this.addUnit("pt", US_PINT, "pt", 1.0, false);
        this.addUnit("cup", US_CUP, "cups", 1.0, false);
        this.addUnit("(?:fl.? oz.?|oz. fl.)", US_FL_OUNCE, "fl oz", 1.0, false);
        this.addUnit("quarts?", US_QUART, "quarts", 1.0, false);
        this.addUnit("gallons?", US_GALLON, "gallons", 1.0, false);
        this.addUnit("pints?", US_PINT, "pints", 1.0, false);
        this.addUnit("cups?", US_CUP, "cups", 1.0, false);
        this.addUnit("(fluid )?ounces?", US_FL_OUNCE, "fluid ounces", 1.0, false);
    }

    @Override
    public String getId() {
        return "METRIC_UNITS_EN_US";
    }
}

