/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

public class EnglishWordRepeatRule
extends WordRepeatRule {
    public EnglishWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"This <marker>is is</marker> just an example sentence."), Example.fixed((String)"This <marker>is</marker> just an example sentence."));
    }

    public String getId() {
        return "ENGLISH_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (position == 0) {
            return false;
        }
        String word = tokens[position].getToken();
        if (this.wordRepetitionOf("had", tokens, position) && this.posIsIn(tokens, position - 2, "PRP", "NN")) {
            return true;
        }
        if (this.wordRepetitionOf("that", tokens, position) && this.posIsIn(tokens, position + 1, "NN", "PRP$", "JJ", "VBZ", "VBD")) {
            return true;
        }
        if (this.wordRepetitionOf("can", tokens, position) && this.posIsIn(tokens, position - 1, "NN")) {
            return true;
        }
        if (this.wordRepetitionOf("hip", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("hooray")) {
            return true;
        }
        if (this.wordRepetitionOf("wild", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("west")) {
            return true;
        }
        if (this.wordRepetitionOf("far", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("away")) {
            return true;
        }
        if (this.wordRepetitionOf("so", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("much")) {
            return true;
        }
        if (this.wordRepetitionOf("so", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("many")) {
            return true;
        }
        if (this.wordRepetitionOf("s", tokens, position) && position > 1 && tokens[position - 2].getToken().matches("['\u2019`\u00b4\u2018]")) {
            return true;
        }
        if (this.wordRepetitionOf("a", tokens, position) && position > 1 && tokens[position - 2].getToken().equals(".")) {
            return true;
        }
        if (this.wordRepetitionOf("on", tokens, position) && position > 1 && tokens[position - 2].getToken().equals(".")) {
            return true;
        }
        if (tokens[position - 1].getToken().equalsIgnoreCase(word) && (position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase(word) || position > 1 && tokens[position - 2].getToken().equalsIgnoreCase(word))) {
            return true;
        }
        if (tokens[position].getToken().matches("(?i)^[a-z]$") && position > 1 && tokens[position - 2].getToken().matches("(?i)^[a-z]$") && position + 1 < tokens.length && tokens[position + 1].getToken().matches("(?i)^[a-z]$")) {
            return true;
        }
        if (this.wordRepetitionOf("blah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("uh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("paw", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yum", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("wop", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("woop", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ha", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("omg", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("boo", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("tick", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("twinkle", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ta", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("la", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("x", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("hi", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ho", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("heh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("jay", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("walla", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("sri", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("xiao", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("hey", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("hah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("heh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("oh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ouh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("chop", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ring", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("beep", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("bleep", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yeah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("wait", tokens, position) && position == 2) {
            return true;
        }
        if (this.wordRepetitionOf("quack", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("meow", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("squawk", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("whoa", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("si", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("honk", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("brum", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("chi", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("santorio", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("lapu", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("chow", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("beep", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("shh", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yummy", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("boom", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("bye", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("aah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("bang", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("woof", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("wink", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yes", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("tsk", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("hush", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("ding", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("choo", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Phi", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Bora", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("tuk", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yadda", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Pago", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Wagga", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Duran", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("sapiens", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("tse", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Li", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("no", tokens, position)) {
            return true;
        }
        if (tokens[position].getToken().endsWith("ay")) {
            if (tokens[position - 1].getToken().equals("may") && tokens[position].getToken().equals("May")) {
                return true;
            }
            if (tokens[position - 1].getToken().equals("May") && tokens[position].getToken().equals("may")) {
                return true;
            }
            if (tokens[1].getToken().equals("May") && tokens[2].getToken().equals("May")) {
                return true;
            }
        } else if (tokens[position].getToken().endsWith("ill")) {
            return position > 0 && tokens[position - 1].getToken().equals("will") && tokens[position].getToken().equals("Will") || tokens[position - 1].getToken().equals("Will") && tokens[position].getToken().equals("will") || tokens[1].getToken().equals("Will") && tokens[2].getToken().equals("Will");
        }
        return false;
    }

    private boolean posIsIn(AnalyzedTokenReadings[] tokens, int position, String ... posTags) {
        if (position >= 0 && position < tokens.length) {
            for (String posTag : posTags) {
                if (!tokens[position].hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean wordRepetitionOf(String word, AnalyzedTokenReadings[] tokens, int position) {
        return tokens[position - 1].getToken().equalsIgnoreCase(word) && tokens[position].getToken().equalsIgnoreCase(word);
    }
}

