/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CoverageDataManagerImpl
extends CoverageDataManager
implements Disposable,
PersistentStateComponent<Element> {
    private final List<CoverageSuiteListener> myListeners;
    private static final Logger LOG = Logger.getInstance(CoverageDataManagerImpl.class);
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites;
    private boolean myIsProjectClosing;
    private final Object myLock;
    private boolean mySubCoverageIsActive;
    private final VirtualFileContentsChangedAdapter myContentListener;
    private Set<LocalFileSystem.WatchRequest> myWatchRequests;
    private List<String> myCurrentSuiteRoots;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK;
    private final Map<Editor, CoverageEditorAnnotator> myAnnotators;
    private Alarm myRequestsAlarm;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(final @NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCoverageSuites = new HashSet<CoverageSuite>();
        this.myIsProjectClosing = false;
        this.myLock = new Object();
        this.myContentListener = new VirtualFileContentsChangedAdapter(){

            protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CoverageDataManagerImpl.this.myCurrentSuiteRoots != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), CoverageDataManagerImpl.this.myCurrentSuiteRoots)) {
                    CoverageDataManagerImpl.this.myCurrentSuitesBundle.restoreCoverageData();
                    CoverageDataManagerImpl.this.updateCoverageData(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                }
            }

            protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "fileOrDirectory";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.ANNOTATORS_LOCK = new Object();
        this.myAnnotators = new HashMap<Editor, CoverageEditorAnnotator>();
        this.myRequestsAlarm = null;
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        });
        CoverageViewSuiteListener coverageViewListener = this.createCoverageViewListener();
        if (coverageViewListener != null) {
            this.addSuiteListener(coverageViewListener, this);
        }
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(){

            public void extensionRemoved(@NotNull CoverageRunner coverageRunner, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle suitesBundle;
                if (coverageRunner == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((suitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle()) != null && ContainerUtil.exists((Object[])suitesBundle.getSuites(), suite -> coverageRunner == suite.getRunner())) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                RunManager runManager = RunManager.getInstance((Project)project);
                List configurations = runManager.getAllConfigurationsList();
                for (RunConfiguration configuration : configurations) {
                    CoverageEnabledConfiguration coverageEnabledConfiguration;
                    if (!(configuration instanceof RunConfigurationBase) || (coverageEnabledConfiguration = (CoverageEnabledConfiguration)((RunConfigurationBase)configuration).getCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY)) == null || !Objects.equals(coverageRunner.getId(), coverageEnabledConfiguration.getRunnerId())) continue;
                    coverageEnabledConfiguration.coverageRunnerExtensionRemoved(coverageRunner);
                    ((RunConfigurationBase)configuration).putCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY, null);
                }
                ((RunManagerImpl)runManager).reloadSchemes();
                for (CoverageSuite suite2 : CoverageDataManagerImpl.this.getSuites()) {
                    CoverageRunner runner;
                    if (!(suite2 instanceof BaseCoverageSuite) || (runner = suite2.getRunner()) != coverageRunner) continue;
                    ((BaseCoverageSuite)suite2).setRunner(null);
                }
                ActionToolbarImpl.updateAllToolbarsImmediately();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageRunner";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$3";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(){

            public void extensionRemoved(@NotNull CoverageEngine coverageEngine, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle suitesBundle;
                if (coverageEngine == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((suitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle()) != null && suitesBundle.getCoverageEngine() == coverageEngine) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                CoverageDataManagerImpl.this.myCoverageSuites.removeIf(suite -> suite.getCoverageEngine() == coverageEngine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageEngine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.myProject);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(1);
        }
        for (Element suiteElement : element.getChildren(SUITE)) {
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) {
                CoverageFileProvider fileProvider = BaseCoverageSuite.readDataFileProviderAttribute(suiteElement);
                if (!fileProvider.isValid()) continue;
                continue;
            }
            CoverageSuite suite = null;
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(engine) || (suite = engine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(suite instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)suite).setProject(this.myProject);
                break;
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.myCoverageSuites.add(suite);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element suiteElement = new Element(SUITE);
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
        return element;
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(suite);
        }
        this.myCoverageSuites.remove(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, selectedFileName, fileProvider, ArrayUtilRt.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        String name = CoverageBundle.message("coverage.results.suite.name", config.getName());
        String covFilePath = config.getCoverageFilePath();
        assert (covFilePath != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(covFilePath));
        CoverageSuite suite = CoverageDataManagerImpl.createCoverageSuite(config, name, coverageRunner, fileProvider);
        this.removeCoverageSuite(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        suite.deleteCachedCoverageData();
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] suites = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])suites) : null);
        }
    }

    @Override
    public CoverageSuite @NotNull [] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.myCoverageSuites.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(2);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        if (this.myWatchRequests != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myContentListener);
            this.myWatchRequests = null;
            this.myCurrentSuiteRoots = null;
        }
        this.updateCoverageData(suite);
    }

    private void updateCoverageData(CoverageSuitesBundle suite) {
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        }
        this.myCurrentSuitesBundle = suite;
        this.disposeAnnotators();
        if (suite == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean suiteFileExists = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (suiteFileExists) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(suite);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentSuitesBundle != null) {
                int answer;
                String[] stringArray;
                String message = CoverageBundle.message("display.coverage.prompt", suite.getPresentableName());
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$5", "getDoNotShowMessage"));
                    }
                };
                if (this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray2[1] = CoverageBundle.message("coverage.add.to.active.suites", new Object[0]);
                    stringArray = stringArray2;
                    stringArray2[2] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray = stringArray3;
                    stringArray3[1] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                }
                String[] options = stringArray;
                int n = answer = doNotAskOption.isToBeShown() ? Messages.showDialog((String)message, (String)CoverageBundle.message("code.coverage", new Object[0]), (String[])options, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (answer == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (answer == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.renewInformationInEditors();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
            CoverageViewManager.getInstance(this.myProject).setReady(true);
        });
    }

    @Override
    public void attachToProcess(final @NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(5);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
                handler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$6", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(6);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<? extends CoverageSuite> suites) {
        this.myCurrentSuiteRoots = ContainerUtil.map(suites, suite -> suite.getCoverageDataFileName());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        this.myCurrentSuiteRoots.forEach(path -> fileSystem.refreshAndFindFileByPath(path));
        this.myWatchRequests = fileSystem.addRootsToWatch(this.myCurrentSuiteRoots, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myContentListener);
    }

    public void dispose() {
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void renewInformationInEditors() {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            this.applyInformationToEditor(allEditors, openFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInformationToEditor(FileEditor[] editors, VirtualFile file) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            CoverageEditorAnnotator annotator;
            Object object;
            Editor textEditor;
            CoverageEngine engine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    annotator = this.myAnnotators.remove(textEditor);
                }
                if (annotator == null) break;
                Disposer.dispose((Disposable)annotator);
                break;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                annotator = this.getAnnotator(textEditor);
                if (annotator == null) {
                    annotator = engine.createSrcFileAnnotator(psiFile, textEditor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(textEditor, annotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !engine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                annotator.showCoverage(this.myCurrentSuitesBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(8);
        }
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap<String, Set<Integer>> executionTrace = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, executionTrace);
        }
        ProjectData projectData = new ProjectData();
        for (String className : executionTrace.keySet()) {
            ClassData loadedClassData = projectData.getClassData(className);
            if (loadedClassData == null) {
                loadedClassData = projectData.getOrCreateClassData(className);
            }
            Set lineNumbers = (Set)executionTrace.get(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int maxNumber = oldLines.length;
            for (Integer lineNumber : lineNumbers) {
                if (lineNumber < maxNumber) continue;
                maxNumber = lineNumber + 1;
            }
            LineData[] lines = new LineData[maxNumber];
            for (Integer line : lineNumbers) {
                LineData oldLineData;
                int lineIdx = line - 1;
                String methodSig = null;
                if (lineIdx < oldData.getLines().length && (oldLineData = oldData.getLineData(lineIdx)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(lineIdx, methodSig);
                if (methodSig != null) {
                    loadedClassData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[lineIdx] = lineData;
            }
            loadedClassData.setLines(lines);
        }
        suite.setCoverageData(projectData);
        this.renewCoverageData(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(9);
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CoverageEditorAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (CoverageEditorAnnotator annotator : this.myAnnotators.values()) {
                if (annotator == null) continue;
                Disposer.dispose((Disposable)annotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private static CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, String name, CoverageRunner coverageRunner, DefaultCoverageFileProvider fileProvider) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && engine.isApplicableTo(config.getConfiguration()) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, config)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(10);
        }
        return coverageSuite;
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageRunner coverageRunner, String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled, false, this.myProject)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(11);
        }
        return coverageSuite;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CoverageProjectManagerListener
    implements ProjectManagerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            if (project == null) {
                CoverageProjectManagerListener.$$$reportNull$$$0(0);
            }
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            Object object = manager.myLock;
            synchronized (object) {
                manager.myIsProjectClosing = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageDataManagerImpl$CoverageProjectManagerListener", "projectClosing"));
        }
    }

    public static class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Map<Editor, Runnable> myCurrentEditors = new HashMap<Editor, Runnable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            PsiFile psiFile;
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            if (manager.myCurrentSuitesBundle != null && (psiFile = (PsiFile)ReadAction.compute(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = editor.getDocument();
                return documentManager.getPsiFile(document);
            })) != null && psiFile.isPhysical()) {
                CoverageEngine engine = manager.myCurrentSuitesBundle.getCoverageEngine();
                if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                CoverageEditorAnnotator annotator = manager.getAnnotator(editor);
                if (annotator == null) {
                    annotator = engine.createSrcFileAnnotator(psiFile, editor);
                }
                CoverageEditorAnnotator finalAnnotator = annotator;
                Object object = manager.ANNOTATORS_LOCK;
                synchronized (object) {
                    manager.myAnnotators.put(editor, finalAnnotator);
                }
                Runnable request = () -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    CoverageSuitesBundle suitesBundle = manager.myCurrentSuitesBundle;
                    if (suitesBundle != null && engine.acceptedByFilters(psiFile, suitesBundle)) {
                        finalAnnotator.showCoverage(suitesBundle);
                    }
                };
                this.myCurrentEditors.put(editor, request);
                CoverageEditorFactoryListener.getRequestsAlarm(manager).addRequest(request, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)project.getServiceIfCreated(CoverageDataManagerImpl.class);
            try {
                CoverageEditorAnnotator fileAnnotator;
                if (manager == null) {
                    return;
                }
                Object object = manager.ANNOTATORS_LOCK;
                synchronized (object) {
                    fileAnnotator = manager.myAnnotators.remove(editor);
                }
                if (fileAnnotator != null) {
                    Disposer.dispose((Disposable)fileAnnotator);
                }
            }
            finally {
                Runnable request = this.myCurrentEditors.remove(editor);
                if (request != null && manager != null) {
                    CoverageEditorFactoryListener.getRequestsAlarm(manager).cancelRequest(request);
                }
            }
        }

        @RequiresEdt
        private static Alarm getRequestsAlarm(@NotNull CoverageDataManagerImpl manager) {
            Alarm alarm;
            if (manager == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(2);
            }
            if ((alarm = manager.myRequestsAlarm) == null) {
                manager.myRequestsAlarm = alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)manager);
            }
            return alarm;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRequestsAlarm";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

